package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryAwardDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryAwardOverviewDTO;
import com.bxm.localnews.merchant.param.activity.LotteryAwardManagePageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 夺宝活动奖品相关服务接口
 *
 * @author liujia
 * @date 2020-10-26 16:19
 **/
public interface LotteryAwardService {

    /**
     * 运营管理后台分页查询奖品信息
     *
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<LotteryAwardOverviewDTO> query(LotteryAwardManagePageParam param);

    /**
     * 根据奖品ID获取奖品详情
     *
     * @param awardId 奖品ID
     * @return 奖品详情
     */
    LotteryAwardDetailDTO get(Long awardId);

    /**
     * 新增或更新奖品信息
     * 如果奖品是商品，则扣除对应的库存信息，新增时直接扣除，更新时根据上一次的库存信息进行扣除
     *
     * @param awardInfo 奖品信息
     * @return 更新结果
     */
    Message saveOrUpdate(LotteryAwardDetailDTO awardInfo);

    /**
     * 模糊查询奖品信息
     *
     * @param awardTitle 奖品标题
     * @return 奖品信息列表
     */
    List<LotteryAwardDetailDTO> searchAward(String awardTitle);

    /**
     * 获取与奖品绑定的活动，并且奖品已过期，但是活动仍然属于启用状态的活动ID列表
     *
     * @return 已过期的活动ID列表
     */
    List<Long> getExpiredLotteryWithAward();

    /**
     * 开启活动时，扣减奖品库存
     *
     * @param awardId 奖品ID
     * @param num     变更的库存数量，正数表示退还库存，负数表示扣除库存
     * @return 扣除结果
     */
    Message changeStock(Long awardId, int num);
}
