package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCalculateDTO;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseDetailParam;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import org.springframework.scheduling.annotation.Async;

/**
 * 执行夺宝活动的开奖逻辑
 *
 * @author liujia
 * @date 2020-10-26 16:25
 **/
public interface LotteryDrawService {

    /**
     * 异步执行开奖逻辑处理
     *
     * @param context 活动参与上下文信息
     */
    @Async
    void execAsyncDraw(LotteryJoinContext context);

    /**
     * 获取夺宝活动的计算过程
     *
     * @param param 夺宝活动信息
     * @return 计算过程的相关数据
     */
    LotteryPhaseCalculateDTO get(LotteryPhaseDetailParam param);
}
