package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.entity.lottery.ActivityInviteHistoryEntity;

/**
 * 夺宝活动的邀请关系相关逻辑
 *
 * @author liujia
 * @date 2020-10-26 16:24
 **/
public interface LotteryInviteService {
    /**
     * 用户是否可以给分享人助力
     * 一个用户可以给分享人在一个活动中助力一次
     *
     * @param userId      当前用户ID
     * @param shareUserId 分享活动的用户ID
     * @param bizId       当前用户参与的活动ID
     * @return true表示可以助力
     */
    boolean match(Long userId, Long shareUserId, Long bizId);

    /**
     * 保持用户邀请记录
     *
     * @param entity 邀请记录信息
     */
    void save(ActivityInviteHistoryEntity entity);
}
