package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.*;
import com.bxm.localnews.merchant.param.activity.*;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 夺宝活动相关的列表复合对象
 * 用于组装前端、客户端需要的列表数据，跨越多个业务对象
 *
 * @author liujia
 * @date 2020-10-26 16:21
 **/
public interface LotteryListCompositeService {
    /**
     * 查询【商家中心-夺宝】吸粉模块中的夺宝列表信息，根据传入的状态进行查询
     * 进行中：查询所有进行中的活动，以活动为主体
     * 未开始：查询所有未开始的活动，以活动为主体
     * 已结束：查询所有已结束的活动期数和所有已下架活动期数，以期数为主体
     *
     * @param param 查询夺宝吸粉列表入参
     * @return 活动列表
     */
    PageWarper<MerchantLotteryAwardDTO> queryMerchantLotteryList(MerchantLotteryAwardPageParam param);

    /**
     * 查询【商家中心-夺宝吸粉】，各种状态下tab栏下的活动数量
     * 已结束状态返回列表中活动的期数
     *
     * @param param 查询夺宝吸粉数量入参
     * @return 活动列表tab数量
     */
    List<MerchantLotteryCountDTO> awardListCount(MerchantLotteryAwardCountParam param);

    /**
     * 分页获取往期揭晓列表
     *
     * @param param 查询入参
     * @return 期数列表
     */
    PageWarper<LotteryPhaseOverviewDTO> historyPublishList(LotteryParam param);

    /**
     * 分页获取进行中的夺宝活动【正在开奖】列表
     *
     * @param param 查询入参
     * @return 期数列表
     */
    PageWarper<LotteryPhaseOverviewDTO> underwayList(LotteryBasePageParam param);

    /**
     * 分页获取近期开奖的夺宝活动【近期结果】列表
     *
     * @param param 查询入参
     * @return 期数列表
     */
    PageWarper<LotteryPhaseOverviewDTO> recentList(LotteryBasePageParam param);

    /**
     * 获取夺宝活动的近期开奖历史（往期中奖）列表，
     *
     * @param param 查询入参
     * @return 期数列表
     */
    List<LotteryPhaseOverviewDTO> historyList(LotteryParam param);

    /**
     * 分页获取我参与的夺宝活动【我参与的】
     *
     * @param param 查询入参
     * @return 期数列表
     */
    PageWarper<LotteryPhaseOverviewDTO> myJoinPhaseList(LotteryBasePageParam param);

    /**
     * 夺宝活动的相关活动推荐（更多夺宝）站外
     *
     * @param param 查询入参
     * @return 期数列表
     */
    PageWarper<LotteryPhaseOverviewDTO> recommendList(LotteryMorePhaseParam param);

    /**
     * 返回夺宝主页弹幕信息【夺宝主页弹幕】
     *
     * @param param 查询入参
     * @return 夺宝主页弹幕信息
     */
    LotteryWinnerCarouselDTO lotteryCarousel(LotteryBaseParam param);


    /**
     * 分页查询本期活动的参与记录【本期参与记录】
     *
     * @param param 查询入参
     * @return 分页的本期活动参与记录
     */
    PageWarper<LotteryParticipatorDTO> joinRecordList(LotteryParticipatorPageParam param);

    /**
     * 分页查询我的中奖记录【我的夺宝】-【中奖记录】
     *
     * @param param 查询入参
     * @return 我的中奖记录列表
     */
    PageWarper<LotteryWinnerOverviewDTO> myWinnerPhaseList(LotteryBasePageParam param);

    /**
     * 分页查询中奖用户列表【弹幕中奖人数点击弹窗】
     *
     * @param param 查询入参
     * @return 当前地区所有的中奖用户列表
     */
    List<LotteryWinnerInfoDTO> queryWinnerList(LotteryBaseParam param);
}
