package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryMerchantInfoDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantGoodsListDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantLastPhaseDTO;
import com.bxm.localnews.merchant.param.activity.LotteryMerchantFollowParam;

import java.util.List;

/**
 * 夺宝活动商家相关的逻辑处理
 *
 * @author liujia
 * @date 2020-10-28 11:37
 **/
public interface LotteryMerchantService {

    /**
     * 执行异步的商家关注逻辑
     *
     * @param param 关注商家的逻辑
     */
    void execAsyncFollow(LotteryMerchantFollowParam param);

    /**
     * 获取报名参与夺宝的商家信息
     *
     * @param merchantId 商家ID
     * @return 商家信息
     */
    LotteryMerchantInfoDTO get(Long merchantId);

    /**
     * 获取报名参与夺宝的商家信息(并返回当前用户是否关注商家)
     *
     * @param merchantId    商家ID
     * @param currentUserId 当前用户id
     * @return 商家信息
     */
    LotteryMerchantInfoDTO get(Long merchantId, Long currentUserId);

    /**
     * 获取指定商户是否有进行中的夺宝活动，如果有返回当前进行中的期数信息
     *
     * @param merchantId 商户id
     * @return 商家正在进行中的最新的期数信息
     */
    MerchantLastPhaseDTO getMerchantHasProceedPhase(Long merchantId);

    /**
     * 获取商户商品列表 默认展示2个
     *
     * @param merchantId 商户id
     * @return 返回商户商品列表
     */
    List<MerchantGoodsListDTO> getMerchantGoods(Long merchantId);
}
