package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinStateDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.param.activity.LotteryAddVirtualParam;
import com.bxm.localnews.merchant.param.activity.LotteryCheckJoinTimesParam;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.newidea.component.vo.Message;

/**
 * 夺宝活动参与者相关服务接口
 *
 * @author liujia
 * @date 2020-10-26 16:20
 **/
public interface LotteryParticipatorService {

    /**
     * 用户参与夺宝活动
     *
     * @param param 参与参数
     * @return 夺宝参与结果
     */
    LotteryJoinResultDTO join(LotteryPhaseJoinParam param);

    /**
     * 保持用户的参与记录，进行数据填充
     * 填充设置用户的参与编码
     *
     * @param entity 用户参与信息
     * @return 保存结果
     */
    Message save(LotteryParticipatorEntity entity);

    /**
     * 统计参与活动的不同用户类型的数量
     *
     * @param phaseId  活动期数ID
     * @param userType 用户类型
     * @return 参与人数
     */
    int countUserType(Long phaseId, LotteryUserTypeEnum userType);

    /**
     * 增加虚拟用户
     * 每半个小时分布15-30（可配置）个虚拟用户加入到夺宝活动
     *
     * @param phaseId 活动期数ID
     */
    void addVirtual(Long phaseId);

    /**
     * 批量增加虚拟用户
     *
     * @param param 增加虚拟用户的参数
     */
    void addVirtual(LotteryAddVirtualParam param);

    /**
     * 获取用户参与某一期活动的可参与次数的相关信息
     * 站外：每个用户可参与一次
     * 站内：根据活动获取剩余的可参与次数
     * 免费参与：新用户（当日注册）可免费参与2次
     *
     * @param param 检查参数
     * @return 检查结果
     */
    LotteryJoinStateDTO getJoinInfo(LotteryCheckJoinTimesParam param);
}
