package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotterySharePosterDTO;
import com.bxm.localnews.merchant.param.activity.LotteryPhasePosterDetailParam;
import com.bxm.newidea.component.vo.Message;

/**
 * 夺宝活动期数相关业务接口
 *
 * @author liujia
 * @date 2020-10-26 16:19
 **/
public interface LotteryPhaseService {

    /**
     * 开启一期新的活动
     * 扣除奖品库存
     * 更新活动信息中的最新一期活动
     * 更新活动期数的最新一期活动
     *
     * @param lotteryId 活动ID
     * @return 开启结果
     */
    Message create(Long lotteryId);

    /**
     * 取消一期活动
     * 退还奖品库存
     * 移除活动期数的最新一期活动
     *
     * @param lotteryId 活动ID
     * @param phaseId   活动期ID
     * @param focus     是否强制终止
     * @return 操作结果
     */
    Message cancel(Long lotteryId, Long phaseId, boolean focus);

    /**
     * 关闭活动，将活动设置为已关闭状态
     * 尝试开启新一期的活动
     *
     * @param lotteryId 活动ID
     * @param phaseId   活动期ID
     * @return 操作结果
     */
    Message close(Long lotteryId, Long phaseId);

    /**
     * 重新开启活动
     *
     * @return
     */
    Message resume(Long lotteryId, Long phaseId);

    /**
     * 获取夺宝活动分享海报所需信息
     *
     * @param param 查询入参
     * @return 分享海报所需信息
     */
    LotterySharePosterDTO getSharePosterInfo(LotteryPhasePosterDetailParam param);


}
