package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.ActivityPrizeInfoDTO;
import com.bxm.localnews.merchant.dto.activity.ActivityPrizeManageDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryCheckResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerManageDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityPrizeEntity;
import com.bxm.localnews.merchant.param.activity.LotteryPrizeCheckParam;
import com.bxm.localnews.merchant.param.activity.LotteryPrizeParam;
import com.bxm.localnews.merchant.param.activity.LotteryWinnerManagePageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 夺宝活动中奖奖品相关服务接口
 *
 * @author liujia
 * @date 2020-10-26 16:23
 **/
public interface LotteryPrizeService {
    /**
     * 分页获取中奖奖品信息【后台管理】
     *
     * @param param 查询中奖奖品信息入参
     * @return 中奖奖品列表
     */
    PageWarper<LotteryWinnerManageDTO> selectByPage(LotteryWinnerManagePageParam param);

    /**
     * 获取奖品发奖信息详情【后台管理】
     *
     * @param prizeId 中奖奖品id
     * @return 发奖信息详情
     */
    ActivityPrizeManageDTO getPrizeDetail(Long prizeId);

    /**
     * 保存奖品发奖信息【后台管理】
     *
     * @param param 发奖信息入参
     */
    void save(ActivityPrizeManageDTO param);

    /**
     * 保存奖品信息
     *
     * @param entity 奖品信息
     * @return 保存结果
     */
    Message savePrizeInfo(ActivityPrizeEntity entity);

    /**
     * 执行奖品核销，将奖品设置为已核销状态
     *
     * @param param 核销参数
     * @return 核销结果
     */
    LotteryCheckResultDTO check(LotteryPrizeCheckParam param);

    /**
     * 获取核销奖品信息
     * 如果核销码不存在或者核销码不属于当前用户，则返回核销码不存在的提示信息
     *
     * @param param 核销码参数
     * @return 核销奖品信息
     */
    ActivityPrizeInfoDTO getPrizeInfo(LotteryPrizeParam param);
}
