package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchants.vo.MerchantInfo;

import java.util.Date;

/**
 * 夺宝活动的相关消息推送
 *
 * @author liujia
 * @date 2020-10-31 13:41
 **/
public interface LotteryPushService {


    /**
     * 夺宝活动开奖后的通知
     *
     * @param userId       参与夺宝活动ID
     * @param lotteryTitle 夺宝活动标题
     */
    void lotteryDraw(Long userId, String lotteryTitle);

    /**
     * 创建夺宝活动后，给商家推送消息
     *
     * @param merchantId     商家ID
     * @param merchantUserId 商家对应的用户ID
     * @param startTime      夺宝活动预计开始时间
     */
    void createLottery(Long merchantId, Long merchantUserId, Date startTime);

    /**
     * 夺宝活动期数开始时推送给店家用户
     *
     * @param merchantUserId 夺宝活动关联的店家用户ID
     * @param phaseNum       活动期数编号
     * @param phaseId        活动期数ID
     * @param lotteryId      活动ID
     */
    void startPhase(Long merchantUserId, Integer phaseNum, Long phaseId, Long lotteryId);

    /**
     * 夺宝活动期数结束时推送给店家用户
     *
     * @param merchantId     商家ID
     * @param merchantUserId 夺宝活动关联的店家用户ID
     * @param phaseNum       活动期数编号
     */
    void finishPhase(Long merchantId, Long merchantUserId, Integer phaseNum);

    /**
     * 夺宝活动奖品核销成功后，给商家推送消息
     *
     * @param merchantId     商家ID
     * @param merchantUserId 夺宝活动关联的店家用户ID
     * @param phaseNum       活动期数编号
     */
    void checkSuccess(Long merchantId, Long merchantUserId, Integer phaseNum);

    /**
     * 夺宝活动开奖后的通知
     *
     * @param userId       参与夺宝活动ID
     * @param context 公共参数
     * @param merchantInfo 商户信息
     * @param lotteryTitle 夺宝活动标题
     */
    void lotteryDrawOfficeAccountMsg(MerchantInfo merchantInfo, LotteryJoinContext context, String lotteryTitle,Long userId,String areaName);
}
