package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryDetailFacadeDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryOverviewDTO;
import com.bxm.localnews.merchant.param.activity.LotteryChangeStatusParam;
import com.bxm.localnews.merchant.param.activity.LotteryManageParam;
import com.bxm.localnews.merchant.param.activity.LotteryRemoveParam;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 夺宝活动相关的服务接口
 *
 * @author liujia
 * @date 2020-10-26 16:19
 **/
public interface LotteryService {


    /**
     * 活动上、下架操作
     * 如果有进行中的活动期数，则尝试下线该期数，如果下线失败，仍然将活动设置为下架状态
     *
     * @param param  活动上下架参数
     * @param status 活动状态，如果是下架则额外设置不同的状态用于记录下架原因
     * @return 操作结果
     */
    Message changeStatus(LotteryChangeStatusParam param, LotteryStatusEnum status);

    /**
     * 移除夺宝活动
     *
     * @param param 移除参数
     * @return 移除结果
     */
    Message remove(LotteryRemoveParam param);

    /**
     * 获取夺宝活动详情
     *
     * @param lotteryId 夺宝活动ID
     * @return 活动详情
     */
    LotteryDetailDTO get(Long lotteryId);

    /**
     * 设置活动的最后一期信息
     * 如果活动最后一期的参数为null，则移除活动的最后一期ID
     *
     * @param lotteryId    活动ID
     * @param lastPhaseId  活动最后一期的ID,如果为null则进行擦除
     * @param lastPhaseNum 活动最后一期的期数
     * @return 设置结果
     */
    Message setLastPhase(Long lotteryId, Long lastPhaseId, Integer lastPhaseNum);

    /**
     * 新增或编辑夺宝活动
     * 新增和编辑后的活动处于下架状态
     *
     * @param param 夺宝活动保存的相关参数，根据是否存在ID判断新增还是编辑
     * @return 编辑结果
     */
    Message saveOrUpdate(LotteryDetailDTO param);

    /**
     * 运营后台分页查询活动信息
     *
     * @param param 分页查询参数
     * @return 分页结果
     */
    PageWarper<LotteryOverviewDTO> query(LotteryManageParam param);

    /**
     * 查询当前地区可用的最新一期活动信息【用于夺宝活动内部接口】
     *
     * @param areaCode 地区编码
     * @return 最新一期可用的活动信息
     */
    LotteryDetailFacadeDTO queryLastEnableLotteryInfo(String areaCode);
}
