package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.service.lottery.event.LotteryEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryFollowEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryJoinEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryShowEvent;

/**
 * 夺宝活动相关的行为数据
 *
 * @author liujia
 * @date 2020-10-26 16:24
 **/
public interface LotteryStatisticsService {

    /**
     * 提交相关的统计事件
     *
     * @param event 夺宝活动事件
     */
    void post(LotteryEvent event);

    /**
     * 初始化活动期数数据
     *
     * @param lotteryId 活动ID
     * @param phaseId   活动期数ID
     */
    void setup(Long lotteryId, Long phaseId);

    /**
     * 监听夺宝活动曝光数据
     *
     * @param event 曝光事件
     */
    void addLotteryShow(LotteryShowEvent event);

    /**
     * 监听夺宝活动参与数据
     *
     * @param event 参与事件
     */
    void addLotteryJoin(LotteryJoinEvent event);

    /**
     * 监听夺宝活动吸粉数据
     *
     * @param event 关注事件
     */
    void addLotteryFollow(LotteryFollowEvent event);
}
