package com.bxm.localnews.merchant.service.lottery;

import com.bxm.localnews.merchant.dto.activity.LotteryPosterInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerAwardDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerDialogDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryWinnerEntity;
import com.bxm.localnews.merchant.param.activity.LotteryAwardAndPostParam;
import com.bxm.localnews.merchant.param.activity.LotteryBaseParam;
import com.bxm.localnews.merchant.param.activity.LotteryWinnerParam;
import com.bxm.newidea.component.vo.Message;

/**
 * 夺宝活动中奖者相关服务接口
 *
 * @author liujia
 * @date 2020-10-26 16:23
 **/
public interface LotteryWinnerService {

    /**
     * 保存获奖者信息
     *
     * @return 保存结果
     */
    Message saveWinner(LotteryWinnerEntity entity);


    /**
     * 获取用户是否有未领奖的中奖信息【用于首页、夺宝页面等弹窗】
     * 每次只返回一个未领奖的中奖信息
     *
     * @param param 查询入参
     * @return 未领奖的中奖信息
     */
    LotteryWinnerDialogDTO getUserWinnerDialogInfo(LotteryBaseParam param);


    /**
     * 获取中奖人员分享的海报信息
     *
     * @param param 查询入参
     * @return 中奖人员的海报信息
     */
    LotteryPosterInfoDTO getWinnerPosterInfo(LotteryWinnerParam param);

    /**
     * 查看用户中奖的奖品信息【查看奖品】
     *
     * @param param 查询入参
     * @return 查看奖品展示的信息
     */
    LotteryWinnerAwardDTO getWinnerAwardInfo(LotteryWinnerParam param);

    /**
     * 领奖并发帖
     *
     * @param param 领奖信息入参
     */
    void awardAndPost(LotteryAwardAndPostParam param);

}
