package com.bxm.localnews.merchant.service.lottery.context;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinStateDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

/**
 * 用户参与夺宝活动的上下文对象
 *
 * @author liujia
 * @date 2020-10-27 15:41
 **/
@Data
@Builder
public class LotteryJoinContext {
    @Tolerate
    public LotteryJoinContext() {
    }

    /**
     * 原始的请求参数
     */
    private LotteryPhaseJoinParam param;

    /**
     * 当前操作的活动期的相关参数，用于进行业务逻辑处理
     */
    private LotteryPhaseCoreInfoDTO phaseInfo;

    /**
     * 指定匹配特殊的参与策略，优先级最高
     */
    private LotteryJoinSourceEnum joinSource;

    /**
     * 当前参与夺宝用户的用户数量，包含当前参与人
     * 在前置检查中进行设置，在参与成功后用于判断是否需要触发开奖
     */
    private Long currentJoinNum;

    /**
     * 当前参与活动的用户是否关注了商家用户，在判断关注关系时进行赋值，减少后置流程的关注处理
     */
    private Boolean followMerchantUser;

    /**
     * 当前参与活动的用户信息
     * 在参与成功后设值
     */
    private UserInfoDTO userInfo;

    /**
     * 跳过触发开奖的操作，用于保存最后一条
     */
    private Boolean skipTriggerDraw;

    /**
     * 跳过真实用户参与人数限制（为测试方便一些）
     */
    private Boolean skipActualLimit;

    /**
     * 强制指定用户的参与时间，用于控制开奖规则，马甲号参与的情况特有
     */
    private Date joinTime;

    /**
     * 用户的参与次数状态记录，在前置检查时存储
     */
    private LotteryJoinStateDTO joinTimesInfo;

    /**
     * 用户参与成功的编码,仅限参与成功
     */
    private String joinCode;
}
