package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.merchant.domain.lottery.ActivityTrackMapper;
import com.bxm.localnews.merchant.dto.activity.ActivityTrackOverviewDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityTrack;
import com.bxm.localnews.merchant.param.activity.ActivityTrackManageParam;
import com.bxm.localnews.merchant.param.activity.ActivityTrackParam;
import com.bxm.localnews.merchant.param.activity.ChangeTrackRemarkParam;
import com.bxm.localnews.merchant.service.lottery.ActivityTrackService;
import com.bxm.newidea.component.tools.InputFilter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 夺宝商家赞助活动线索Service实现类
 *
 * @author wzy
 * @version 1.0
 * @date 2020/10/26 2:31 下午
 */
@Service
public class ActivityTrackServiceImpl implements ActivityTrackService {

    @Resource
    private ActivityTrackMapper activityTrackMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public void addTrack(ActivityTrackParam param) {
        ActivityTrack newTrack = new ActivityTrack();
        BeanUtils.copyProperties(param, newTrack);

        newTrack.setContent(InputFilter.builder(param.getContent()).filte());

        newTrack.setId(sequenceCreater.nextLongId());
        newTrack.setCreateTime(new Date());
        // 等于3说明是站外
        if (PlatformEnum.WEB.getCode() == param.getPlatform()) {
            newTrack.setSource((byte) 2);
        } else {
            //否则是站内
            newTrack.setSource((byte) 1);
        }
        activityTrackMapper.insertSelective(newTrack);
    }

    @Override
    public PageWarper<ActivityTrackOverviewDTO> queryByPage(ActivityTrackManageParam param) {


        startPage(param.getPageNum(), param.getPageSize());
        PageInfo<ActivityTrack> activityTrackPageInfo = new PageInfo<>(activityTrackMapper.queryByPage(param));

        List<ActivityTrackOverviewDTO> trackOverviewDTOList = new ArrayList<>();
        activityTrackPageInfo.getList().forEach(item -> {
            ActivityTrackOverviewDTO trackOverviewDTO = new ActivityTrackOverviewDTO();
            BeanUtils.copyProperties(item, trackOverviewDTO);
            trackOverviewDTO.setTrackId(item.getId());

            trackOverviewDTOList.add(trackOverviewDTO);
        });

        //返回分页信息
        PageWarper<ActivityTrackOverviewDTO> activityTrackInfo = new PageWarper<>(trackOverviewDTOList);
        activityTrackInfo.setTotal(activityTrackPageInfo.getTotal());
        activityTrackInfo.setPageNum(activityTrackPageInfo.getPageNum());
        activityTrackInfo.setPageSize(activityTrackPageInfo.getPageSize());
        activityTrackInfo.setPages(activityTrackPageInfo.getPages());

        return activityTrackInfo;
    }

    @Override
    public void modifyRemark(ChangeTrackRemarkParam param) {
        ActivityTrack updateTrack = new ActivityTrack();
        updateTrack.setId(param.getTrackId());
        updateTrack.setRemark(param.getRemark());
        updateTrack.setOperator(param.getCurrentUserId());
        updateTrack.setRemarkTime(new Date());

        activityTrackMapper.updateByPrimaryKeySelective(updateTrack);

    }
}