package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.domain.lottery.ActivityInviteHistoryMapper;
import com.bxm.localnews.merchant.entity.lottery.ActivityInviteHistoryEntity;
import com.bxm.localnews.merchant.service.lottery.LotteryInviteService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liujia
 * @date 2020-10-27 14:49
 **/
@Service
@Slf4j
public class LotteryInviteServiceImpl implements LotteryInviteService {

    private final ActivityInviteHistoryMapper activityInviteHistoryMapper;

    private final SequenceCreater sequenceCreater;

    @Autowired
    public LotteryInviteServiceImpl(ActivityInviteHistoryMapper activityInviteHistoryMapper,
                                    SequenceCreater sequenceCreater) {
        this.activityInviteHistoryMapper = activityInviteHistoryMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public boolean match(Long userId, Long shareUserId, Long bizId) {
        return activityInviteHistoryMapper.queryMatchRecord(userId, shareUserId, bizId) == 0;
    }

    @Override
    public void save(ActivityInviteHistoryEntity entity) {
        entity.setId(sequenceCreater.nextLongId());
        entity.setStatus(1);

        activityInviteHistoryMapper.insert(entity);
    }
}
