package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.merchant.common.utils.URLUtils;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.integration.MsgPushIntegrationService;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author liujia
 * @date 2020-10-31 13:54
 **/
@Service
@Slf4j
@AllArgsConstructor
public class LotteryPushServiceImpl implements LotteryPushService {

    private final MessageSender messageSender;

    private final DomainIntegrationService domainIntegrationService;

    private final MsgPushIntegrationService msgPushIntegrationService;

    private final LotteryParticipatorMapper lotteryParticipatorMapper;

    private final ActivityProperties activityProperties;

    private final LocationIntegrationService locationIntegrationService;

    @Override
    public void lotteryDraw(Long userId, String lotteryTitle) {
        String title = "夺宝开奖通知";
        String content = "你参与的\"" + lotteryTitle + "\"已开奖，快看看中奖的是不是你！去看看>>";

        ImmutableMap<String, Object> paramMap = ImmutableMap.of(
                "userId", "{userId}",
                "areaName", "{areaName}",
                "areaCode", "{areaCode}");

        String protocolUrl = buildH5Url("/tk/raffle.html#/myRaffleList", paramMap);

        PushMessage message = PushMessage.build(title, content)
                .assign(userId)
                .setPayloadInfo(PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));

        messageSender.sendPushMessage(message);

    }

    @Override
    public void createLottery(Long merchantId, Long merchantUserId, Date startTime) {
        String title = "夺宝活动创建完成";

        int tabSelect;
        String startTimeStr;

        if (null == startTime || DateUtils.before(startTime, new Date())) {
            tabSelect = 1;
            startTimeStr = "活动已经开始";
        } else {
            startTimeStr = "活动将于" + DateUtils.DATE_TIME_FORMAT_THREAD_LOCAL.get().format(startTime) + "开始";
            tabSelect = 2;
        }

        String content = "您的夺宝活动已创建完成，" + startTimeStr + "，点击查看详情";

        ImmutableMap<String, Object> paramMap = ImmutableMap.of(
                "userId", "{userId}",
                "merchantId", merchantId,
                "tabSelect", tabSelect,
                "areaCode", "{areaCode}");

        String protocolUrl = buildH5Url("/tk/raffle.html#/raffleList", paramMap);

        PushMessage message = PushMessage.build(title, content)
                .assign(merchantUserId)
                .setPayloadInfo(PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));

        messageSender.sendPushMessage(message);
    }

    @Override
    public void startPhase(Long merchantUserId, Integer phaseNum, Long phaseId, Long lotteryId) {
        String title = "您的夺宝活动开始了";
        String content = "您的夺宝活动【第" + phaseNum + "期】已经开始了，赶快去分享给更多好友参与吧";

        ImmutableMap<String, Object> paramMap = ImmutableMap.of(
                "userId", "{userId}",
                "phaseId", phaseId,
                "lotteryId", lotteryId,
                "areaName", "{areaName}",
                "areaCode", "{areaCode}");

        String protocolUrl = buildH5Url("/tk/raffle.html#/details", paramMap);

        PushMessage message = PushMessage.build(title, content)
                .assign(merchantUserId)
                .setPayloadInfo(PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));

        messageSender.sendPushMessage(message);
    }

    @Override
    public void finishPhase(Long merchantId, Long merchantUserId, Integer phaseNum) {
        String title = "您的夺宝活动已结束";
        String content = "您的夺宝活动【第" + phaseNum + "期】已结束，请准备好中奖顾客到店消费的准备哦";

        pushRaffleListMessage(merchantId, merchantUserId, title, content);
    }

    @Override
    public void checkSuccess(Long merchantId, Long merchantUserId, Integer phaseNum) {
        String title = "夺宝商品核销成功";
        String content = "夺宝活动【第" + phaseNum + "期】的中奖用户核销成功，报名更多夺宝活动，为店铺曝光引流哦~";

        pushRaffleListMessage(merchantId, merchantUserId, title, content);
    }

    private void pushRaffleListMessage(Long merchantId, Long merchantUserId, String title, String content) {
        ImmutableMap<String, Object> paramMap = ImmutableMap.of(
                "userId", "{userId}",
                "merchantId", merchantId,
                "tabSelect", 3,
                "areaCode", "{areaCode}");

        String protocolUrl = buildH5Url("/tk/raffle.html#/raffleList", paramMap);

        PushMessage message = PushMessage.build(title, content)
                .assign(merchantUserId)
                .setPayloadInfo(PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));

        messageSender.sendPushMessage(message);
    }

    private String buildH5Url(String pageUrl, Map<String, Object> paramMap) {
        return URLUtils.buildH5Url(domainIntegrationService.getInnerH5BaseUrl(), pageUrl, paramMap);
    }

    @Override
    public void lotteryDrawOfficeAccountMsg(MerchantInfo merchantInfo, LotteryJoinContext context, String lotteryTitle, Long userId, String areaName) {
        Long phaseId = context.getParam().getPhaseId();
        List<LotteryParticipatorEntity> userLotteryCode = lotteryParticipatorMapper.getUserLotteryCodeByPhaseId(userId, phaseId, activityProperties.getMaxCodeSize());
        List<String> codeList = new ArrayList<>();
        userLotteryCode.forEach(lotteryCode -> codeList.add(lotteryCode.getCode()));
        String codes = String.join(",", codeList);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("inviterId", userId);
        paramMap.put("areaCode", context.getParam().getAreaCode());
        paramMap.put("areaName", areaName);
        paramMap.put("lng", merchantInfo.getLng());
        paramMap.put("lat", merchantInfo.getLat());
        paramMap.put("sourcePhaseId", context.getParam().getSourcePhaseId());
        paramMap.put("phaseId", phaseId);
        paramMap.put("lotteryId", context.getPhaseInfo().getLotteryId());
        String protocolUrl = raffleFixedUrl(paramMap);
        msgPushIntegrationService.doOfficialAccountPush(userId, lotteryTitle, codes, protocolUrl);
    }

    private String raffleFixedUrl(Map<String, Object> paramMap) {
        String h5BaseUrl = getH5BaseUrl();
        if (h5BaseUrl == null) {
            return null;
        }
        StringBuilder finalUrl = new StringBuilder(h5BaseUrl);
        finalUrl.append("/tk/raffle.html#/wxdetails");
        if (null != paramMap) {
            finalUrl.append("?");
            paramMap.forEach((key, value) -> {
                finalUrl.append(key).append("=").append(value).append("&");
            });
            finalUrl.deleteCharAt(finalUrl.length() - 1);
        }
        return finalUrl.toString();
    }


    private String getH5BaseUrl() {
        Optional<ViewSceneDomain> viewSceneBaseUrl;
        try {
            viewSceneBaseUrl = domainIntegrationService.getViewSceneBaseUrl(DomainScene.DomainViewScene.WX_JS_VIEW);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return viewSceneBaseUrl.map(ViewSceneDomain::getBaseUrl).orElse(null);
    }

}
