package com.bxm.localnews.merchant.service.lottery.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityPrizeMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryWinnerMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPosterInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerAwardDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerDialogDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityPrizeEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryWinnerEntity;
import com.bxm.localnews.merchant.facade.LocationFeignService;
import com.bxm.localnews.merchant.integration.ForumPostIntegrationService;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryAwardAndPostParam;
import com.bxm.localnews.merchant.param.activity.LotteryBaseParam;
import com.bxm.localnews.merchant.param.activity.LotteryWinnerParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.AwardTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryWinnerStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryWinnerService;
import com.bxm.localnews.merchant.vo.ForumBasicVo;
import com.bxm.localnews.merchant.vo.PostImgVo;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

import static java.lang.String.format;
import static org.apache.commons.lang3.RandomUtils.nextInt;

/**
 * @author liujia
 * @date 2020-10-28 20:50
 **/
@Slf4j
@Service
@AllArgsConstructor
public class LotteryWinnerServiceImpl implements LotteryWinnerService {

    private final LotteryWinnerMapper lotteryWinnerMapper;

    private final ActivityAwardMapper activityAwardMapper;

    private final SequenceCreater sequenceCreater;

    private final MerchantInfoMapper merchantInfoMapper;

    private final ActivityPrizeMapper activityPrizeMapper;

    private final ForumPostIntegrationService forumPostIntegrationService;

    private final LocationIntegrationService locationIntegrationService;

    private final ActivityProperties activityProperties;

    @Override
    public Message saveWinner(LotteryWinnerEntity entity) {
        entity.setId(sequenceCreater.nextLongId());
        return Message.build(lotteryWinnerMapper.insert(entity));
    }

    @Override
    public LotteryWinnerDialogDTO getUserWinnerDialogInfo(LotteryBaseParam param) {
        return lotteryWinnerMapper.getUserUnReceiveInfo(param);
    }

    @Override
    public LotteryPosterInfoDTO getWinnerPosterInfo(LotteryWinnerParam param) {
        return lotteryWinnerMapper.getWinnerPosterInfo(param);
    }

    @Override
    public LotteryWinnerAwardDTO getWinnerAwardInfo(LotteryWinnerParam param) {
        LotteryWinnerEntity lotteryWinnerEntity = lotteryWinnerMapper.selectByPrimaryKey(param.getWinnerRecordId());
        // 1、获取奖品信息award
        Long awardId = lotteryWinnerEntity.getAwardId();
        LotteryAwardEntityWithBLOBs awardInfo = activityAwardMapper.selectByPrimaryKey(awardId);

        if (awardInfo == null) {
            return new LotteryWinnerAwardDTO();
        }

        LotteryWinnerAwardDTO resultDTO = new LotteryWinnerAwardDTO();
        resultDTO.setAwardTitle(awardInfo.getTitle());
        resultDTO.setAwardType(awardInfo.getType());

        //如果是商家商品作为奖品
        if (awardInfo.getType().equals(AwardTypeEnum.GOODS.getCode())) {
            Long merchantId = awardInfo.getMerchantId();
            //获取商家信息
            MerchantInfo merchantInfo = merchantInfoMapper.selectByPrimaryKey(merchantId);
            resultDTO.setMerchantAddress(merchantInfo.getAddress());
            resultDTO.setMerchantPhone(merchantInfo.getMobile());
            //获取中奖奖品信息prize
            ActivityPrizeEntity winnerPrizeInfo = activityPrizeMapper.getPrizeInfoByWinnerId(param.getWinnerRecordId());
            //设置奖品核销码
            resultDTO.setCode(winnerPrizeInfo.getCode());
        } else {
            //其他奖品
            //TODO 根据地区获取地区客服微信号,暂时让前端调1-04-7 根据地区code获取客服信息，获取客服信息
        }
        return resultDTO;
    }

    @Override
    public void awardAndPost(LotteryAwardAndPostParam param) {
        if (param.getWinnerRecordId() == null) {
            log.warn("领奖时传入的中奖记录id不能为空：{}", param);
            return;
        }
        //1、领奖
        LotteryWinnerEntity lotteryWinnerEntity =
                lotteryWinnerMapper.selectByPrimaryKey(param.getWinnerRecordId());
        if (lotteryWinnerEntity == null) {
            log.warn("中奖记录不存在：{}", param);
            return;
        }
        if (!LotteryWinnerStatusEnum.UN_RECEIVE.getCode().equals(lotteryWinnerEntity.getStatus())) {
            log.warn("中奖记录必须为未领取：{}", param);
            return;
        }
        LotteryWinnerEntity updateWinnerEntity = new LotteryWinnerEntity();
        //更新状态为已领取
        updateWinnerEntity.setId(param.getWinnerRecordId());
        updateWinnerEntity.setStatus(LotteryWinnerStatusEnum.RECEIVE.getCode());

        lotteryWinnerMapper.updateByPrimaryKeySelective(updateWinnerEntity);

        // 创建炫耀帖子
        createFlauntPost(param, lotteryWinnerEntity);
    }

    /**
     * 创建炫耀帖子
     *
     * @param param 接口请求参数
     * @param lotteryWinnerEntity 中奖信息
     */
    private void createFlauntPost(LotteryAwardAndPostParam param, LotteryWinnerEntity lotteryWinnerEntity) {

        if (log.isDebugEnabled()) {
            log.debug("创建炫耀帖子, param: {} lottery: {}", JSON.toJSONString(param), JSON.toJSONString(lotteryWinnerEntity));
        }

        if (CollectionUtils.isEmpty(activityProperties.getFlauntTexts())
                || CollectionUtils.isEmpty(activityProperties.getExtraContents())) {
            log.warn("炫耀帖子文案配置为空，无法发送炫耀帖子, param: {} lottery: {}", JSON.toJSONString(param),
                    JSON.toJSONString(lotteryWinnerEntity));
            return;
        }

        try{

            // 随机获取一个文案
            String flauntText = activityProperties.getFlauntTexts().get(nextInt(0, activityProperties.getFlauntTexts().size()));
            // 随机获取一个点击文案
            String extText = activityProperties.getExtraContents().get(nextInt(0, activityProperties.getExtraContents().size()));

            LotteryAwardEntityWithBLOBs lotteryAward = activityAwardMapper.selectByPrimaryKey(lotteryWinnerEntity.getAwardId());

            if (Objects.isNull(lotteryAward)) {
                log.warn("奖品: {} 不存在，无法发送炫耀帖子", lotteryWinnerEntity.getAwardId());
                return;
            }

            // 替换标题
            flauntText = format(flauntText, lotteryAward.getTitle());
            // 将点击标签的占位内容进行实例化 期数id和点击文案
            extText = format(activityProperties.getExtraContentElement(), lotteryWinnerEntity.getPhaseId(), extText);

            ForumBasicVo forumBasicVo = new ForumBasicVo();
            forumBasicVo.setUserId(lotteryWinnerEntity.getUserId());
            forumBasicVo.setAreaCode(param.getAreaCode());

            LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(param.getAreaCode());
            if (Objects.nonNull(locationDTO)) {
                forumBasicVo.setLocation(locationDTO.getName());
            }

            // 帖子内容
            forumBasicVo.setTextField(flauntText);
            // 拓展帖子内容数据 跳转用的
            forumBasicVo.setExtraContent(extText);
            forumBasicVo.setTopicIdList(Collections.singletonList(activityProperties.getFlauntTopicId()));
            forumBasicVo.setIsNewReport((byte) 0);
            forumBasicVo.setPostImgList(Collections.singletonList(PostImgVo.buildImg(param.getPosterUrl())));

            // 调用内部接口创建帖子
            forumPostIntegrationService.createPost(forumBasicVo);
        } catch (Exception e) {
            log.error("创建炫耀帖子出现错误, param: {} lottery: {}", JSON.toJSONString(param),
                    JSON.toJSONString(lotteryWinnerEntity), e);
        }

    }
}
