package com.bxm.localnews.merchant.service.lottery.strategy;

import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;

/**
 * 用户参与活动的不同处理策略
 *
 * @author liujia
 * @date 2020-10-27 15:58
 **/
public interface IJoinStrategy {

    /**
     * 策略是否匹配
     *
     * @param context 参与活动的相关参数上下文
     * @return true表示策略匹配
     */
    boolean match(LotteryJoinContext context);

    /**
     * 执行相关逻辑处理
     *
     * @param context 参与夺宝的参数上下文
     * @return 参与夺宝的处理结果
     */
    LotteryJoinResultDTO execute(LotteryJoinContext context);
}
