package com.bxm.localnews.merchant.service.lottery.strategy.impl;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryInviteService;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 邀请用户成功获取参与机会
 * 邀请用户参与活动成功则增加一次参与机会
 *
 * @author liujia
 * @date 2020-10-27 16:28
 **/
@Component
public class InviteJoinStrategy extends AbstractJoinStrategy {

    @Resource
    private LotteryInviteService lotteryInviteService;

    @Override
    public boolean match(LotteryJoinContext context) {
        return LotteryJoinSourceEnum.INVITE.equals(context.getJoinSource());
    }

    @Override
    void fillParticipator(LotteryParticipatorEntity entity) {
        entity.setSource(LotteryJoinSourceEnum.INVITE.getCode());
        entity.setUserType(LotteryUserTypeEnum.ACTURAL.getCode());
    }

    @Override
    LotteryJoinResultDTO afterExecute(LotteryJoinContext context) {
        // 上报用户通过邀请获取夺宝码成功
        bizLogIntegrationService.point(PointReportParam.build(context.getParam())
                .e("3034")
                .ev("128." + context.getPhaseInfo().getPhaseId())
                .put("uid", String.valueOf(context.getParam().getUserId()))
                .put("a", context.getParam().getAreaCode())
        );
        return super.afterExecute(context);
    }
}
