package com.bxm.localnews.merchant.service.task;

import com.bxm.localnews.merchant.domain.lottery.LotteryMapper;
import com.bxm.localnews.merchant.entity.lottery.LotteryEntity;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryPhaseService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.vo.Message;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 夺宝活动自动启用的回调处理
 * 根据夺宝活动设置的开启时间，定期开启活动，如果活动处于未上架状态，则不做处理
 *
 * @author liujia
 * @date 2020-10-26 20:28
 **/
@Slf4j
@Component
public class LotteryAutoEnableCallback extends AbstractTaskCallback<Long> {

    @Resource
    private LotteryPhaseService lotteryPhaseService;

    @Resource
    private LotteryMapper lotteryMapper;

    @Override
    protected ReturnT<String> service(Long lotteryId) {
        LotteryEntity updateEntity = new LotteryEntity();
        updateEntity.setId(lotteryId);
        updateEntity.setStatus(LotteryStatusEnum.ACTIVED.getCode());

        lotteryMapper.updateByPrimaryKeySelective(updateEntity);

        Message message = lotteryPhaseService.create(lotteryId);

        if (!message.isSuccess()) {
            log.info("活动[{}]开启失败，错误消息：{}", lotteryId, message.getLastMessage());
        }
        return ReturnT.SUCCESS;
    }
}
