package com.bxm.localnews.merchant.service.task;

import com.bxm.localnews.merchant.param.activity.LotteryChangeStatusParam;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryAwardService;
import com.bxm.localnews.merchant.service.lottery.LotteryService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 夺宝活动奖品过期的定时任务
 *
 * @author liujia
 * @date 2020-10-26 18:58
 **/
@Component
public class LotteryAwardExpiredTask extends AbstractCronTask {

    @Resource
    private LotteryAwardService lotteryAwardService;

    @Resource
    private LotteryService lotteryService;

    @Override
    protected ReturnT<String> service(Object o) {
        List<Long> expiredLotteries = lotteryAwardService.getExpiredLotteryWithAward();

        for (Long expiredLottery : expiredLotteries) {
            //设置活动过期
            LotteryChangeStatusParam param = new LotteryChangeStatusParam();
            param.setLotteryId(expiredLottery);
            param.setEnable(false);

            lotteryService.changeStatus(param, LotteryStatusEnum.EXPIRED);
        }

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return LotteryAwardExpiredTask.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/1 * * * ?";
    }
}
