package com.bxm.localnews.merchant.service.task;

import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.service.enums.LotteryPhaseStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryParticipatorService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 给进行中的需要填充马甲号的夺宝活动增加参与人信息
 *
 * @author liujia
 */
@Component
public class LotteryVirtualTimer extends AbstractCronTask<Long> {

    private final LotteryParticipatorService lotteryParticipatorService;

    private final LotteryPhaseMapper lotteryPhaseMapper;

    @Autowired
    public LotteryVirtualTimer(LotteryParticipatorService lotteryParticipatorService,
                               LotteryPhaseMapper lotteryPhaseMapper) {
        this.lotteryParticipatorService = lotteryParticipatorService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
    }


    @Override
    protected ReturnT<String> service(Long param) {
        List<Long> goingPhase = lotteryPhaseMapper.getVirtualJoinPhase(LotteryPhaseStatusEnum.GOING.getCode());

        if (!CollectionUtils.isEmpty(goingPhase)) {
            goingPhase.forEach(lotteryParticipatorService::addVirtual);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String description() {
        return "给进行中的活动增加虚拟用户";
    }

    @Override
    public String taskName() {
        return LotteryVirtualTimer.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0/5 * 7-22 * * ?";
    }
}