/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.impl;

import com.bxm.localnews.merchant.dto.ActionRecordTraceIdDTO;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.param.activity.ActivityAdvertParam;
import com.bxm.localnews.merchant.security.facade.dto.RelationshipDto;
import com.bxm.localnews.merchant.security.facade.service.MerchantMemberFacadeService;
import com.bxm.localnews.merchant.service.activity.ActivityService;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchant.service.activity.ticket.TicketHandlerChain;
import com.bxm.localnews.merchant.service.count.MerchantActionRecordService;
import com.bxm.localnews.merchant.service.count.MerchantPageCollectService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LogManager.getLogger(ActivityServiceImpl.class);
    private MerchantMemberFacadeService merchantMemberFacadeService;
    private TicketHandlerChain ticketHandlerChain;
    private MerchantActionRecordService merchantActionRecordService;
    private MerchantPageCollectService merchantPageCollectService;

    @Override
    public ActivityAdvertInfoDTO activityAdvertUp(ActivityAdvertParam param) {
        if (log.isDebugEnabled()) {
            log.debug("ActivityAdvertParam : {}", (Object)param);
        }
        if (Objects.isNull(param.getShareUserId())) {
            return null;
        }
        String traceId = this.traceIdDo(param);
        this.viewContent(param, traceId);
        RelationshipDto relationshipDto = this.merchantMemberFacadeService.getRelationship(param.getShareUserId());
        return this.ticketHandlerChain.excuter(this.makeTicketContext(param, relationshipDto, traceId));
    }

    private TicketContext makeTicketContext(ActivityAdvertParam param, RelationshipDto relationshipDto, String traceId) {
        TicketContext ticketContext = TicketContext.builder().merchantId(Objects.nonNull(relationshipDto) ? relationshipDto.getMerchantId() : null).traceId(traceId).build();
        BeanUtils.copyProperties((Object)param, (Object)((Object)ticketContext));
        return ticketContext;
    }

    private void viewContent(ActivityAdvertParam param, String traceId) {
        if (StringUtils.isBlank((CharSequence)param.getActorUserId())) {
            return;
        }
        MerchantReportParam merchantReportParam = new MerchantReportParam();
        merchantReportParam.setTraceId(traceId);
        merchantReportParam.setToken(param.getActorUserId());
        this.merchantPageCollectService.viewContent(merchantReportParam);
    }

    private String traceIdDo(ActivityAdvertParam param) {
        ActionRecordTraceIdDTO actionRecordTraceIdDTO = new ActionRecordTraceIdDTO();
        actionRecordTraceIdDTO.setBelonger(param.getShareUserId());
        actionRecordTraceIdDTO.setRelationId(param.getContentId());
        actionRecordTraceIdDTO.setRelationType(param.getContentType());
        String traceId = this.merchantActionRecordService.getTraceByRidBelonger(actionRecordTraceIdDTO);
        if (log.isDebugEnabled()) {
            log.debug("traceIdDo  traceId : {}", (Object)traceId);
        }
        return StringUtils.isNotBlank((CharSequence)traceId) ? traceId : null;
    }

    public ActivityServiceImpl(MerchantMemberFacadeService merchantMemberFacadeService, TicketHandlerChain ticketHandlerChain, MerchantActionRecordService merchantActionRecordService, MerchantPageCollectService merchantPageCollectService) {
        this.merchantMemberFacadeService = merchantMemberFacadeService;
        this.ticketHandlerChain = ticketHandlerChain;
        this.merchantActionRecordService = merchantActionRecordService;
        this.merchantPageCollectService = merchantPageCollectService;
    }
}

