/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.impl;

import com.bxm.localnews.merchant.domain.ActivityUnicomInfoMapper;
import com.bxm.localnews.merchant.domain.ActivityUnicomPhoneInfoMapper;
import com.bxm.localnews.merchant.entity.UnicomInfo;
import com.bxm.localnews.merchant.entity.UnicomPhoneInfo;
import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.param.activity.UnicomMatchPhoneParam;
import com.bxm.localnews.merchant.param.activity.UnicomParam;
import com.bxm.localnews.merchant.service.activity.UnicomService;
import com.bxm.localnews.merchant.service.count.MerchantPageCollectService;
import com.bxm.localnews.merchant.utils.ValidatorlUtils;
import com.bxm.localnews.msg.facade.SmsFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.Validater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UnicomServiceImpl
implements UnicomService {
    private static final Logger log = LogManager.getLogger(UnicomServiceImpl.class);
    private ActivityUnicomInfoMapper activityUnicomInfoMapper;
    private ActivityUnicomPhoneInfoMapper activityUnicomPhoneInfoMapper;
    private SmsFacadeService smsFacadeService;
    private MerchantPageCollectService merchantPageCollectService;
    private static String PROVINCE = "330000";

    @Override
    public Message saveUnicomUserInfo(UnicomParam unicomParam) {
        log.debug("unicomParam {}", (Object)unicomParam);
        Message checkResult = this.checkParam(unicomParam);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        this.saveUnicom(unicomParam);
        this.afterLogic(unicomParam);
        return Message.build().setSuccess(true);
    }

    @Async
    public void afterLogic(UnicomParam unicomParam) {
        MerchantReportParam merchantReportParam = new MerchantReportParam();
        merchantReportParam.setTraceId(unicomParam.getTraceId());
        merchantReportParam.setToken(unicomParam.getActorUserId());
        merchantReportParam.setShareUserId(unicomParam.getShareUserId());
        this.merchantPageCollectService.orderContent(merchantReportParam);
    }

    @Override
    public PageWarper<String> getPhoneList(UnicomMatchPhoneParam unicomMatchPhoneParam) {
        log.debug("unicomMatchPhoneParam {}", (Object)unicomMatchPhoneParam);
        List phoneList = this.activityUnicomPhoneInfoMapper.getPhoneList(unicomMatchPhoneParam);
        return new PageWarper(phoneList);
    }

    private void saveUnicom(UnicomParam unicomParam) {
        UnicomInfo unicomInfo = new UnicomInfo();
        BeanUtils.copyProperties((Object)unicomParam, (Object)unicomInfo);
        this.activityUnicomInfoMapper.saveUnicomInfo(unicomInfo);
        if (Objects.nonNull(unicomParam.getSelectedPhoneNumb())) {
            UnicomPhoneInfo unicomPhoneInfo = UnicomPhoneInfo.builder().idCard(unicomParam.getIdCard()).usable(Integer.valueOf(1)).phoneNumb(unicomParam.getSelectedPhoneNumb().trim()).unicomId(unicomInfo.getId()).build();
            this.activityUnicomPhoneInfoMapper.updateUnicomPhoneInfo(unicomPhoneInfo);
        }
    }

    private Message checkParam(UnicomParam unicomParam) {
        if (!ValidatorlUtils.checkIdentityCode((String)unicomParam.getIdCard())) {
            return Message.build((boolean)false).setMessage("\u8eab\u4efd\u8bc1\u683c\u5f0f\u9519\u8bef");
        }
        if (!Validater.checkPhone((String)unicomParam.getPhone())) {
            return Message.build((boolean)false).setMessage("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        if (!unicomParam.getOwnerProvince().contains(PROVINCE) && StringUtils.isNotBlank((CharSequence)unicomParam.getSelectedPhoneNumb())) {
            return Message.build((boolean)false).setMessage("\u975e\u6d59\u6c5f\u7701\u4e0d\u80fd\u9009\u62e9\u5361\u53f7!");
        }
        boolean checkCode = this.smsFacadeService.verifySmsCodeByType(Byte.valueOf((byte)7), unicomParam.getPhone(), unicomParam.getSmsCode());
        if (!checkCode) {
            return Message.build((boolean)false).setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return Message.build((boolean)true);
    }

    public UnicomServiceImpl(ActivityUnicomInfoMapper activityUnicomInfoMapper, ActivityUnicomPhoneInfoMapper activityUnicomPhoneInfoMapper, SmsFacadeService smsFacadeService, MerchantPageCollectService merchantPageCollectService) {
        this.activityUnicomInfoMapper = activityUnicomInfoMapper;
        this.activityUnicomPhoneInfoMapper = activityUnicomPhoneInfoMapper;
        this.smsFacadeService = smsFacadeService;
        this.merchantPageCollectService = merchantPageCollectService;
    }
}

