/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.activity.ticket.processor;

import com.bxm.localnews.merchant.common.constant.TicketLevelEnum;
import com.bxm.localnews.merchant.dto.activity.ActivityAdvertInfoDTO;
import com.bxm.localnews.merchant.service.activity.ticket.AbstractTicketHandler;
import com.bxm.localnews.merchant.service.activity.ticket.TicketContext;
import com.bxm.localnews.merchants.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoAdvertFacade;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DeployHandlerProcessor
extends AbstractTicketHandler {
    MerchantInfoAdvertFacade merchantInfoManageService;

    @Override
    protected int getHandlerLevel() {
        return TicketLevelEnum.CONFIGURE_LEVEL.getNum();
    }

    @Override
    protected ActivityAdvertInfoDTO response(TicketContext context) {
        if (Objects.isNull(context.getMerchantId())) {
            return null;
        }
        MerchantAdvertInfoDTO merchantAdvertInfoDTO = this.merchantInfoManageService.merchantAdvertInfo(context.getMerchantId());
        if (Objects.isNull(merchantAdvertInfoDTO) || merchantAdvertInfoDTO.getStatus() == 0) {
            return null;
        }
        ActivityAdvertInfoDTO response = new ActivityAdvertInfoDTO();
        response.setImgUrl(merchantAdvertInfoDTO.getImgUrl());
        response.setActivityType(TicketLevelEnum.CONFIGURE_LEVEL.getCode());
        response.setLinkUrl(merchantAdvertInfoDTO.getLinkUrl());
        response.setTitle(merchantAdvertInfoDTO.getTitle());
        response.setTraceId(context.getTraceId());
        return response;
    }

    public DeployHandlerProcessor(MerchantInfoAdvertFacade merchantInfoManageService) {
        this.merchantInfoManageService = merchantInfoManageService;
    }
}

