/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.cache;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.dto.activity.UserJoinCodeDTO;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LotteryCacheManage {
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisStringAdapter redisStringAdapter;
    private final ActivityProperties activityProperties;
    private final RedisSetAdapter redisSetAdapter;
    private TypeReference<List<UserJoinCodeDTO>> joinTypeReference = new TypeReference<List<UserJoinCodeDTO>>(){};

    @Autowired
    public LotteryCacheManage(RedisHashMapAdapter redisHashMapAdapter, RedisStringAdapter redisStringAdapter, ActivityProperties activityProperties, RedisSetAdapter redisSetAdapter) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.activityProperties = activityProperties;
        this.redisSetAdapter = redisSetAdapter;
    }

    public void clearPhaseCache(Long phaseId) {
        this.redisStringAdapter.remove(this.buildJoinNumKey(phaseId));
    }

    private KeyGenerator buildJoinKey(Long userId) {
        return RedisConfig.USER_JOIN_TIMES_MAP.copy().appendKey((Object)userId);
    }

    public Boolean hasGlobalJoinTimes(Long userId) {
        return this.redisSetAdapter.exists(this.buildTodayGlobalJoinUser(), (Object)userId) == false;
    }

    public void consumeGlobalJoinTimes(Long userId) {
        KeyGenerator key = this.buildTodayGlobalJoinUser();
        this.redisSetAdapter.add(key, new Object[]{userId});
        this.redisSetAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator buildTodayGlobalJoinUser() {
        return RedisConfig.TODAY_GLOBAL_JOIN_USER.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
    }

    private KeyGenerator buildFreeJoinUser() {
        return RedisConfig.LOTTERY_FREE_JOIN_USER.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
    }

    public Boolean hasFreeJoinTime(Long userId) {
        Long joinTimes = this.redisHashMapAdapter.getLong(this.buildFreeJoinUser(), userId.toString());
        return joinTimes < (long)this.activityProperties.getFreeTimes().intValue();
    }

    public void consumeFreeJoinTime(Long userId) {
        KeyGenerator key = this.buildFreeJoinUser();
        this.redisHashMapAdapter.increment(key, userId.toString(), 1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    public Long getAppJoinTimes(Long phaseId, Long userId, int maxType) {
        KeyGenerator key = this.buildJoinKey(userId);
        Date now = new Date();
        List userJoinCodes = (List)this.redisHashMapAdapter.get(key, String.valueOf(phaseId), this.joinTypeReference);
        if (null == userJoinCodes) {
            return 0L;
        }
        return userJoinCodes.stream().filter(joinCode -> {
            boolean isApp = Objects.equals(joinCode.getType(), LotteryJoinSourceEnum.APP.getCode());
            return maxType == 0 ? isApp : isApp && Objects.nonNull(joinCode.getJoinTime()) && DateUtils.isSameDay((Date)joinCode.getJoinTime(), (Date)now);
        }).count();
    }

    public void addJoinCode(Long phaseId, Long userId, String joinCode, Integer source) {
        String subKey;
        KeyGenerator key = this.buildJoinKey(userId);
        List userJoinCodes = (List)this.redisHashMapAdapter.get(key, subKey = String.valueOf(phaseId), this.joinTypeReference);
        if (null == userJoinCodes) {
            userJoinCodes = Lists.newArrayList();
        }
        userJoinCodes.add(UserJoinCodeDTO.builder().code(joinCode).type(source).joinTime(new Date()).build());
        this.redisHashMapAdapter.put(key, subKey, (Object)userJoinCodes);
    }

    public Map<Long, List<String>> getMyCodes(List<Long> phaseIds, Long userId) {
        if (CollectionUtils.isEmpty(phaseIds)) {
            return Maps.newHashMap();
        }
        KeyGenerator key = this.buildJoinKey(userId);
        HashMap result = Maps.newHashMap();
        Map entries = this.redisHashMapAdapter.entries(key, this.joinTypeReference);
        entries.forEach((phaseIdStr, codes) -> {
            if (phaseIds.stream().anyMatch(phaseId -> String.valueOf(phaseId).equals(phaseIdStr))) {
                result.put(Long.valueOf(phaseIdStr), codes.stream().map(UserJoinCodeDTO::getCode).collect(Collectors.toList()));
            }
        });
        return result;
    }

    public Boolean hasFollowGrantCoupon(Long userId, Long couponId) {
        return this.redisSetAdapter.exists(this.buildUserFollowCouponKey(userId), (Object)couponId);
    }

    public void followGrantUserCoupon(Long userId, Long couponId) {
        this.redisSetAdapter.add(this.buildUserFollowCouponKey(userId), new Object[]{couponId});
    }

    private KeyGenerator buildUserFollowCouponKey(Long userId) {
        return RedisConfig.USER_FOLLOW_COUPON.copy().appendKey((Object)userId);
    }

    private KeyGenerator buildJoinNumKey(Long phaseId) {
        return RedisConfig.PHASE_JOIN_NUM.copy().appendKey((Object)phaseId);
    }

    public Long incrementJoinNum(Long phaseId) {
        return this.redisStringAdapter.increment(this.buildJoinNumKey(phaseId));
    }

    public Long getJoinNum(Long phaseId) {
        return this.redisStringAdapter.getLong(this.buildJoinNumKey(phaseId));
    }

    public void decrementJoinNum(Long phaseId) {
        this.redisStringAdapter.decrement(this.buildJoinNumKey(phaseId));
    }
}

