/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.merchant.domain.lottery.ActivityTrackMapper;
import com.bxm.localnews.merchant.dto.activity.ActivityTrackOverviewDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityTrack;
import com.bxm.localnews.merchant.param.activity.ActivityTrackManageParam;
import com.bxm.localnews.merchant.param.activity.ActivityTrackParam;
import com.bxm.localnews.merchant.param.activity.ChangeTrackRemarkParam;
import com.bxm.localnews.merchant.service.lottery.ActivityTrackService;
import com.bxm.newidea.component.tools.InputFilter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ActivityTrackServiceImpl
implements ActivityTrackService {
    @Resource
    private ActivityTrackMapper activityTrackMapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public void addTrack(ActivityTrackParam param) {
        ActivityTrack newTrack = new ActivityTrack();
        BeanUtils.copyProperties((Object)param, (Object)newTrack);
        newTrack.setContent(InputFilter.builder((String)param.getContent()).filte());
        newTrack.setId(this.sequenceCreater.nextLongId());
        newTrack.setCreateTime(new Date());
        if (PlatformEnum.WEB.getCode() == param.getPlatform()) {
            newTrack.setSource(Byte.valueOf((byte)2));
        } else {
            newTrack.setSource(Byte.valueOf((byte)1));
        }
        this.activityTrackMapper.insertSelective(newTrack);
    }

    @Override
    public PageWarper<ActivityTrackOverviewDTO> queryByPage(ActivityTrackManageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageInfo activityTrackPageInfo = new PageInfo(this.activityTrackMapper.queryByPage(param));
        ArrayList trackOverviewDTOList = new ArrayList();
        activityTrackPageInfo.getList().forEach(item -> {
            ActivityTrackOverviewDTO trackOverviewDTO = new ActivityTrackOverviewDTO();
            BeanUtils.copyProperties((Object)item, (Object)trackOverviewDTO);
            trackOverviewDTO.setTrackId(item.getId());
            trackOverviewDTOList.add(trackOverviewDTO);
        });
        PageWarper activityTrackInfo = new PageWarper(trackOverviewDTOList);
        activityTrackInfo.setTotal(activityTrackPageInfo.getTotal());
        activityTrackInfo.setPageNum(activityTrackPageInfo.getPageNum());
        activityTrackInfo.setPageSize(activityTrackPageInfo.getPageSize());
        activityTrackInfo.setPages(activityTrackPageInfo.getPages());
        return activityTrackInfo;
    }

    @Override
    public void modifyRemark(ChangeTrackRemarkParam param) {
        ActivityTrack updateTrack = new ActivityTrack();
        updateTrack.setId(param.getTrackId());
        updateTrack.setRemark(param.getRemark());
        updateTrack.setOperator(param.getCurrentUserId());
        updateTrack.setRemarkTime(new Date());
        this.activityTrackMapper.updateByPrimaryKeySelective(updateTrack);
    }
}

