/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.dto.activity.LotteryAwardDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryAwardOverviewDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.param.activity.LotteryAwardManagePageParam;
import com.bxm.localnews.merchant.param.activity.LotteryChangeStatusParam;
import com.bxm.localnews.merchant.service.enums.AwardTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryAwardService;
import com.bxm.localnews.merchant.service.lottery.LotteryService;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryAwardServiceImpl
implements LotteryAwardService {
    private static final Logger log = LoggerFactory.getLogger(LotteryAwardServiceImpl.class);
    private final ActivityAwardMapper activityAwardMapper;
    private final MerchantGoodsMapper merchantGoodsMapper;
    private final SequenceCreater sequenceCreater;
    private final MerchantInfoFacadeService merchantInfoFacadeService;
    private LotteryService lotteryService;

    @Autowired
    public LotteryAwardServiceImpl(ActivityAwardMapper activityAwardMapper, SequenceCreater sequenceCreater, MerchantGoodsMapper merchantGoodsMapper, MerchantInfoFacadeService merchantInfoFacadeService) {
        this.activityAwardMapper = activityAwardMapper;
        this.sequenceCreater = sequenceCreater;
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.merchantInfoFacadeService = merchantInfoFacadeService;
    }

    @Override
    public PageWarper<LotteryAwardOverviewDTO> query(LotteryAwardManagePageParam param) {
        return new PageWarper(this.activityAwardMapper.queryByPage(param));
    }

    @Override
    public LotteryAwardDetailDTO get(Long awardId) {
        MerchantGoodsVo merchantGoodsInfo;
        LotteryAwardEntityWithBLOBs detailEntity = this.activityAwardMapper.selectByPrimaryKey(awardId);
        LotteryAwardDetailDTO detailDTO = new LotteryAwardDetailDTO();
        BeanUtils.copyProperties((Object)detailEntity, (Object)detailDTO);
        detailDTO.setAwardId(detailEntity.getId());
        detailDTO.setAwardTitle(detailEntity.getTitle());
        detailDTO.setAwardType(detailEntity.getType());
        detailDTO.setReplay(detailEntity.getReplayContent());
        detailDTO.setMerchantId(detailEntity.getSponsor());
        detailDTO.setCarouseStr(detailEntity.getCarousel());
        if (detailDTO.getGoodsId() != null && (merchantGoodsInfo = this.merchantGoodsMapper.selectByPrimaryKey(detailDTO.getGoodsId())) != null) {
            detailDTO.setGoodsName(merchantGoodsInfo.getName());
        }
        return detailDTO;
    }

    @Override
    public Message saveOrUpdate(LotteryAwardDetailDTO awardInfo) {
        LotteryAwardEntityWithBLOBs entity = new LotteryAwardEntityWithBLOBs();
        BeanUtils.copyProperties((Object)awardInfo, (Object)entity);
        entity.setId(awardInfo.getAwardId());
        entity.setTitle(awardInfo.getAwardTitle());
        entity.setCarousel(awardInfo.getCarouseStr());
        entity.setType(awardInfo.getAwardType());
        entity.setCreator(awardInfo.getCurrentUserId());
        entity.setReplayContent(awardInfo.getReplay());
        entity.setSponsor(awardInfo.getMerchantId());
        List<Object> carouselList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)awardInfo.getCarouseStr())) {
            carouselList = Arrays.asList(awardInfo.getCarouseStr().split(","));
        }
        if (!CollectionUtils.isEmpty(carouselList)) {
            entity.setFirstImg((String)carouselList.get(0));
        }
        int result = 0;
        entity.setWelfareType(awardInfo.getWelfareType());
        entity.setWelfareId(awardInfo.getWelfareId());
        if (null == awardInfo.getAwardId()) {
            MerchantInfo merchantInfo;
            entity.setCreateTime(new Date());
            entity.setId(this.sequenceCreater.nextLongId());
            entity.setUseStock(Integer.valueOf(0));
            if (Objects.nonNull(entity.getMerchantId()) && Objects.isNull(merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(entity.getMerchantId()))) {
                return Message.build((boolean)false, (String)"\u8d5e\u52a9\u7684\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            result = this.activityAwardMapper.insert(entity);
        } else {
            Message message = this.beforeUpdate(entity);
            if (message.isSuccess()) {
                entity.setModifyTime(new Date());
                result = this.activityAwardMapper.updateByPrimaryKeySelective(entity);
            }
        }
        return Message.build((int)result);
    }

    private Message beforeUpdate(LotteryAwardEntityWithBLOBs entity) {
        LotteryAwardEntityWithBLOBs existsAward;
        if (Objects.equals(entity.getType(), AwardTypeEnum.GOODS.getCode()) && (existsAward = this.activityAwardMapper.selectByPrimaryKey(entity.getId())).getUseStock() > entity.getStock()) {
            log.info("\u5e93\u5b58\u6570\u91cf\u7f16\u8f91\u9519\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)entity));
            return Message.build((boolean)false, (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u5386\u53f2\u5df2\u4f7f\u7528\u5e93\u5b58");
        }
        return Message.build();
    }

    @Override
    public List<LotteryAwardDetailDTO> searchAward(String awardTitle) {
        return this.activityAwardMapper.queryTopMatchAward(awardTitle);
    }

    @Override
    public List<Long> getExpiredLotteryWithAward() {
        return this.activityAwardMapper.queryExpiredLottery(LotteryStatusEnum.ACTIVED.getCode());
    }

    private LotteryService getLotteryService() {
        if (this.lotteryService == null) {
            this.lotteryService = (LotteryService)SpringContextHolder.getBean(LotteryService.class);
        }
        return this.lotteryService;
    }

    @Override
    public Message changeStock(Long awardId, int num) {
        LotteryAwardEntityWithBLOBs awardInfo = this.activityAwardMapper.selectByPrimaryKey(awardId);
        if (num < 0) {
            if (awardInfo.getStock().equals(awardInfo.getUseStock())) {
                log.info("\u5956\u54c1[{}]\u5e93\u5b58\u6263\u9664\u5b8c\u6bd5\uff0c\u66f4\u65b0\u5956\u54c1\u5bf9\u5e94\u7684\u6d3b\u52a8\u72b6\u6001\uff0c\u5c06\u5176\u8bbe\u7f6e\u4e3a\u4e0b\u7ebf", (Object)awardId);
                List activeLotteries = this.activityAwardMapper.queryRelationActionLottery(awardId, LotteryStatusEnum.ACTIVED.getCode());
                for (Long activeLottery : activeLotteries) {
                    LotteryChangeStatusParam changeParam = new LotteryChangeStatusParam();
                    changeParam.setLotteryId(activeLottery);
                    changeParam.setEnable(Boolean.valueOf(false));
                    this.getLotteryService().changeStatus(changeParam, LotteryStatusEnum.STOCK_OVER);
                }
            }
            if (awardInfo.getStock() < awardInfo.getUseStock() + Math.abs(num)) {
                return Message.build((boolean)false, (String)"\u5e93\u5b58\u4e0d\u8db3");
            }
        }
        return Message.build((int)this.activityAwardMapper.updateStock(awardId, num));
    }
}

