/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityInviteHistoryMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryInviteInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinStateDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryParticipatorDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseDetailDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryEntity;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryCheckJoinTimesParam;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseDetailParam;
import com.bxm.localnews.merchant.service.lottery.LotteryDetailCompositeService;
import com.bxm.localnews.merchant.service.lottery.LotteryMerchantService;
import com.bxm.localnews.merchant.service.lottery.LotteryParticipatorService;
import com.bxm.localnews.merchant.service.lottery.LotteryStatisticsService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.localnews.merchant.service.lottery.event.LotteryShowEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryDetailCompositeServiceImpl
implements LotteryDetailCompositeService {
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final LotteryCacheManage lotteryCacheManage;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private final LotteryParticipatorService lotteryParticipatorService;
    private final UserIntegrationService userIntegrationService;
    private final LotteryMapper lotteryMapper;
    private final ActivityAwardMapper activityAwardMapper;
    private final ActivityInviteHistoryMapper activityInviteHistoryMapper;
    private final LotteryMerchantService lotteryMerchantService;
    private final LotteryStatisticsService lotteryStatisticsService;

    public LotteryDetailCompositeServiceImpl(LotteryPhaseMapper lotteryPhaseMapper, LotteryCacheManage lotteryCacheManage, LotteryParticipatorService lotteryParticipatorService, UserIntegrationService userIntegrationService, LotteryMapper lotteryMapper, LotteryParticipatorMapper lotteryParticipatorMapper, ActivityAwardMapper activityAwardMapper, ActivityInviteHistoryMapper activityInviteHistoryMapper, LotteryMerchantService lotteryMerchantService, LotteryStatisticsService lotteryStatisticsService) {
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.lotteryCacheManage = lotteryCacheManage;
        this.lotteryParticipatorService = lotteryParticipatorService;
        this.userIntegrationService = userIntegrationService;
        this.lotteryMapper = lotteryMapper;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.activityAwardMapper = activityAwardMapper;
        this.activityInviteHistoryMapper = activityInviteHistoryMapper;
        this.lotteryMerchantService = lotteryMerchantService;
        this.lotteryStatisticsService = lotteryStatisticsService;
    }

    @Override
    public LotteryPhaseDetailDTO getLotteryDetail(LotteryPhaseDetailParam param) {
        LotteryPhaseDetailDTO phaseDetailResult = this.lotteryPhaseMapper.getPhaseDetail(param);
        LotteryEntity lotteryEntity = this.lotteryMapper.selectByPrimaryKey(phaseDetailResult.getLotteryId());
        LotteryAwardEntityWithBLOBs awardInfo = this.activityAwardMapper.selectByPrimaryKey(lotteryEntity.getAwardId());
        phaseDetailResult.setLastPhaseId(this.getProceedLastPhaseId(lotteryEntity.getId()));
        phaseDetailResult.setImgList(this.getCarouselList(awardInfo.getCarousel()));
        phaseDetailResult.setRecentParticipatorList(this.getRecentParticipatorList(param.getPhaseId()));
        if (param.getUserId() == null && PlatformEnum.WEB.getCode() == param.getPlatform()) {
            phaseDetailResult.setExpendGold(Integer.valueOf(0));
            phaseDetailResult.setJoinTimes(Integer.valueOf(0));
            phaseDetailResult.setMyCodes(Collections.emptyList());
            if (awardInfo.getMerchantId() != null) {
                phaseDetailResult.setMerchantInfo(this.lotteryMerchantService.get(awardInfo.getMerchantId()));
            }
            return phaseDetailResult;
        }
        LotteryJoinStateDTO joinInfo = this.getJoinInfo(lotteryEntity.getMaxTimes(), lotteryEntity.getMaxType(), param.getPhaseId(), param.getUserId(), param.getPlatform());
        phaseDetailResult.setJoinTimes(joinInfo.getJoinTimes());
        phaseDetailResult.setExpendGold(Integer.valueOf(joinInfo.getFree() != false ? 0 : lotteryEntity.getExpendGold()));
        if (awardInfo.getMerchantId() != null) {
            phaseDetailResult.setMerchantInfo(this.lotteryMerchantService.get(awardInfo.getMerchantId(), param.getUserId()));
            phaseDetailResult.getMerchantInfo().setDescription(awardInfo.getIntro());
        }
        List<String> myCodeList = this.getMyCodeList(param.getPhaseId(), param.getUserId());
        phaseDetailResult.setMyCodes(myCodeList);
        if (PlatformEnum.WEB.getCode() != param.getPlatform()) {
            phaseDetailResult.setInviteInfo(this.getInviteInfo(param.getPhaseId(), param.getUserId()));
        }
        this.lotteryStatisticsService.post(new LotteryShowEvent(lotteryEntity.getId(), param.getPhaseId()));
        return phaseDetailResult;
    }

    private LotteryJoinStateDTO getJoinInfo(Integer maxTimes, Integer maxType, Long phaseId, Long userId, Integer platform) {
        UserInfoDTO userCache = this.userIntegrationService.getUserFromRedisDB(userId);
        LotteryCheckJoinTimesParam param = LotteryCheckJoinTimesParam.builder().phaseId(phaseId).platform(platform).userId(userId).userCreateTime(userCache.getCreateTime()).maxTimes(maxTimes).maxType(maxType).build();
        return this.lotteryParticipatorService.getJoinInfo(param);
    }

    public List<String> getMyCodeList(Long phaseId, Long userId) {
        Map<Long, List<String>> codeMap = this.lotteryCacheManage.getMyCodes(Collections.singletonList(phaseId), userId);
        List<String> myCodeList = codeMap.get(phaseId);
        if (CollectionUtils.isEmpty(myCodeList)) {
            return Collections.emptyList();
        }
        return myCodeList;
    }

    public Long getProceedLastPhaseId(Long lotteryId) {
        return this.lotteryPhaseMapper.getProceedLastPhaseId(lotteryId);
    }

    public List<String> getCarouselList(String carousel) {
        if (StringUtils.isBlank((CharSequence)carousel)) {
            return Collections.emptyList();
        }
        return Arrays.asList(carousel.split(","));
    }

    public List<LotteryParticipatorDTO> getRecentParticipatorList(Long phaseId) {
        return this.lotteryParticipatorMapper.getParticipatorListByPhase(phaseId);
    }

    public LotteryInviteInfoDTO getInviteInfo(Long phaseId, Long userId) {
        LotteryInviteInfoDTO resultDTO = new LotteryInviteInfoDTO();
        int inviteNum = this.activityInviteHistoryMapper.countUserInvite(userId, phaseId);
        List userInviteList = this.activityInviteHistoryMapper.getUserInvite(userId, phaseId);
        resultDTO.setInviteNum(Integer.valueOf(inviteNum));
        resultDTO.setInviteUsers(userInviteList);
        return resultDTO;
    }
}

