/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryWinnerMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryAwardDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCalculateDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCalculatePartDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityPrizeEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryWinnerEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseDetailParam;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.ActivityPrizeStatusEnum;
import com.bxm.localnews.merchant.service.enums.AwardTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryPhaseStatusEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryWinnerStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryAwardService;
import com.bxm.localnews.merchant.service.lottery.LotteryDrawService;
import com.bxm.localnews.merchant.service.lottery.LotteryPhaseService;
import com.bxm.localnews.merchant.service.lottery.LotteryPrizeService;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.localnews.merchant.service.lottery.LotteryWinnerService;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.strategy.JoinStrategyManage;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LotteryDrawServiceImpl
implements LotteryDrawService {
    private static final Logger log = LoggerFactory.getLogger(LotteryDrawServiceImpl.class);
    private final JoinStrategyManage joinStrategyManage;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private static final Integer CAL_NUM = 50;
    private final ActivityProperties activityProperties;
    private final UserIntegrationService userIntegrationService;
    private final LotteryPhaseService lotteryPhaseService;
    private final LotteryWinnerService lotteryWinnerService;
    private final LotteryPrizeService lotteryPrizeService;
    private final LotteryAwardService lotteryAwardService;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final LotteryWinnerMapper lotteryWinnerMapper;
    private final LotteryPushService lotteryPushService;
    private final MerchantInfoFacadeService merchantInfoFacadeService;
    private final LocationIntegrationService locationIntegrationService;
    private static final ThreadLocal<DateFormat> CUSTOM_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));

    private LotteryParticipatorEntity getVirtualUser(Date lastJoinTime) {
        List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(1));
        UserInfoDTO userInfoDTO = (UserInfoDTO)virtualUserList.get(0);
        LotteryParticipatorEntity entity = new LotteryParticipatorEntity();
        entity.setUserId(userInfoDTO.getId());
        entity.setNickName(userInfoDTO.getNickname());
        entity.setHeadImg(userInfoDTO.getHeadImg());
        entity.setCreateTime(DateUtils.addField((Date)lastJoinTime, (int)13, (int)1));
        return entity;
    }

    @Override
    public void execAsyncDraw(LotteryJoinContext context) {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("\u6d3b\u52a8\u5f00\u5956\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        List lastJoinUsers = this.lotteryParticipatorMapper.getLastJoinUser(phaseInfo.getPhaseId(), Integer.valueOf(CAL_NUM - 1));
        if (lastJoinUsers.size() < CAL_NUM - 1) {
            log.error("\u6d3b\u52a8[{}]\u5f00\u5956\u5931\u8d25\uff0c\u4eba\u6570\u4e0d\u8db3", (Object)phaseInfo.getPhaseId());
            this.abandonPhase(context);
            return;
        }
        Date lastUserJoinTime = ((LotteryParticipatorEntity)lastJoinUsers.get(0)).getCreateTime();
        LotteryParticipatorEntity virtualUser = this.getVirtualUser(lastUserJoinTime);
        LotteryParticipatorEntity winner = Objects.equals(phaseInfo.getActualFlag(), 1) ? this.lotteryParticipatorMapper.getRandomParticipator(phaseInfo.getPhaseId(), LotteryUserTypeEnum.ACTURAL.getCode()) : this.lotteryParticipatorMapper.getRandomParticipator(phaseInfo.getPhaseId(), LotteryUserTypeEnum.VIRTURAL.getCode());
        if (winner == null) {
            if (Objects.equals(phaseInfo.getActualFlag(), 0)) {
                log.info("\u6d3b\u52a8[{}]\u8bbe\u5b9a\u4e3a\u865a\u62df\u7528\u6237\u5f00\u5956\uff0c\u4f46\u662f\u6ca1\u6709\u8db3\u591f\u7684\u865a\u62df\u7528\u6237\uff0c\u8bbe\u7f6e\u4e3a\u6700\u540e\u4e00\u4f4d\u865a\u62df\u7528\u6237\u76f4\u63a5\u4e2d\u5956", (Object)phaseInfo.getPhaseId());
                virtualUser.setCode(String.valueOf(this.activityProperties.getJoinCodeStartIndex() + (long)phaseInfo.getTargetNum().intValue()));
                winner = virtualUser;
            } else {
                log.error("\u6d3b\u52a8[{}]\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4e2d\u5956\u4eba\u5458", (Object)phaseInfo.getPhaseId());
                this.abandonPhase(context);
                return;
            }
        }
        lastJoinUsers.add(virtualUser);
        long offset = this.getOffset(lastJoinUsers, context, winner);
        virtualUser.setCreateTime(DateUtils.addField((Date)virtualUser.getCreateTime(), (int)14, (int)((int)(-offset))));
        this.afterDraw(context, virtualUser, winner);
    }

    private void abandonPhase(LotteryJoinContext context) {
        log.error("\u5f3a\u5236\u7ec8\u6b62\u6d3b\u52a8\uff0c\u5e76\u5c1d\u8bd5\u91cd\u65b0\u5f00\u542f\uff0c\u76f8\u5173\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        this.lotteryPhaseService.cancel(phaseInfo.getLotteryId(), phaseInfo.getPhaseId(), true);
        this.lotteryPhaseService.create(phaseInfo.getLotteryId());
    }

    private void afterDraw(LotteryJoinContext context, LotteryParticipatorEntity virtualUser, LotteryParticipatorEntity winner) {
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        this.addLastJoinVirtual(context, virtualUser);
        Message message = this.lotteryPhaseService.close(phaseInfo.getLotteryId(), phaseInfo.getPhaseId());
        if (message.isSuccess()) {
            this.addWinner(context, winner, virtualUser.getCreateTime());
            this.lotteryPhaseService.create(phaseInfo.getLotteryId());
            List joinUserIds = this.lotteryParticipatorMapper.getJoinUserIds(phaseInfo.getPhaseId(), LotteryUserTypeEnum.ACTURAL.getCode());
            LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(context.getParam().getAreaCode());
            MerchantInfo merchantInfo = null;
            if (phaseInfo.getMerchantId() != null) {
                merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(phaseInfo.getMerchantId());
            }
            for (Long userId : joinUserIds) {
                this.lotteryPushService.lotteryDraw(userId, phaseInfo.getLotteryTitle());
                this.lotteryPushService.lotteryDrawOfficeAccountMsg(merchantInfo, context, phaseInfo.getLotteryTitle(), userId, locationByGeocode.getName());
            }
        }
    }

    private void addWinner(LotteryJoinContext context, LotteryParticipatorEntity winner, Date winnerTime) {
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        UserInfoDTO cacheUser = this.userIntegrationService.getUserFromRedisDB(winner.getUserId());
        LotteryWinnerEntity entity = new LotteryWinnerEntity();
        entity.setAwardId(phaseInfo.getAwardId());
        entity.setCode(Integer.valueOf(winner.getCode()));
        entity.setCreateTime(winnerTime);
        entity.setUserId(winner.getUserId());
        entity.setHeadImg(winner.getHeadImg());
        entity.setNickName(winner.getNickName());
        entity.setPhone(cacheUser.getPhone());
        entity.setPhaseId(phaseInfo.getPhaseId());
        entity.setLotteryId(phaseInfo.getLotteryId());
        entity.setStatus(LotteryWinnerStatusEnum.UN_RECEIVE.getCode());
        Message message = this.lotteryWinnerService.saveWinner(entity);
        if (message.isSuccess()) {
            LotteryAwardDetailDTO awardInfo = this.lotteryAwardService.get(entity.getAwardId());
            ActivityPrizeEntity prizeEntity = new ActivityPrizeEntity();
            prizeEntity.setBizId(entity.getId());
            prizeEntity.setCreateTime(winnerTime);
            prizeEntity.setType(awardInfo.getAwardType());
            if (Objects.equals(AwardTypeEnum.GOODS.getCode(), awardInfo.getAwardType())) {
                prizeEntity.setStatus(ActivityPrizeStatusEnum.GRANT.getCode());
            } else {
                prizeEntity.setStatus(ActivityPrizeStatusEnum.UN_GRANT.getCode());
            }
            this.lotteryPrizeService.savePrizeInfo(prizeEntity);
        }
    }

    private void addLastJoinVirtual(LotteryJoinContext context, LotteryParticipatorEntity virtualUser) {
        LotteryPhaseJoinParam param = new LotteryPhaseJoinParam();
        param.setUserId(virtualUser.getUserId());
        param.setPhaseId(context.getPhaseInfo().getPhaseId());
        LotteryJoinContext joinContext = LotteryJoinContext.builder().param(param).joinSource(LotteryJoinSourceEnum.VIRTUAL).skipTriggerDraw(true).joinTime(virtualUser.getCreateTime()).build();
        this.joinStrategyManage.execute(joinContext);
    }

    private long getOffset(List<LotteryParticipatorEntity> lastJoinUsers, LotteryJoinContext context, LotteryParticipatorEntity winner) {
        long sum = lastJoinUsers.stream().mapToLong(joinUser -> this.convert(joinUser.getCreateTime())).sum();
        Integer targetNum = context.getPhaseInfo().getTargetNum();
        long winnerNum = sum % (long)targetNum.intValue() + 1L;
        long winnerCode = Long.valueOf(winner.getCode()) - this.activityProperties.getJoinCodeStartIndex();
        return winnerNum - winnerCode;
    }

    private Long convert(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        String finalNumStr = hour + String.format("%02d", minute) + String.format("%02d", second) + String.format("%03d", millisecond);
        return NumberUtils.toLong((String)finalNumStr);
    }

    @Override
    public LotteryPhaseCalculateDTO get(LotteryPhaseDetailParam param) {
        LotteryPhaseCoreInfoDTO corePhaseInfo = this.lotteryPhaseMapper.getCorePhaseInfo(param.getPhaseId());
        if (null == corePhaseInfo || !Objects.equals(corePhaseInfo.getStatus(), LotteryPhaseStatusEnum.FINISH.getCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u6d3b\u52a8[{}]\u8fd8\u672a\u7ed3\u675f\uff0c\u4e0d\u663e\u793a\u8ba1\u7b97\u8fc7\u7a0b", (Object)param.getPhaseId());
            }
            return LotteryPhaseCalculateDTO.builder().build();
        }
        List lastJoinUserList = this.lotteryParticipatorMapper.getLastJoinUser(param.getPhaseId(), CAL_NUM);
        LotteryWinnerEntity winner = this.lotteryWinnerMapper.selectByPhaseId(param.getPhaseId());
        long total = lastJoinUserList.stream().mapToLong(user -> this.convert(user.getCreateTime())).sum();
        List partList = lastJoinUserList.stream().map(user -> LotteryPhaseCalculatePartDTO.builder().joinTime(CUSTOM_FORMAT.get().format(user.getCreateTime())).partJoinTime(String.valueOf(this.convert(user.getCreateTime()))).build()).collect(Collectors.toList());
        return LotteryPhaseCalculateDTO.builder().totalNum(corePhaseInfo.getTargetNum()).total(Long.valueOf(total)).partList(partList).result(String.valueOf(winner.getCode())).build();
    }

    @Autowired
    public LotteryDrawServiceImpl(JoinStrategyManage joinStrategyManage, LotteryParticipatorMapper lotteryParticipatorMapper, ActivityProperties activityProperties, UserIntegrationService userIntegrationService, LotteryPhaseService lotteryPhaseService, LotteryWinnerService lotteryWinnerService, LotteryPrizeService lotteryPrizeService, LotteryAwardService lotteryAwardService, LotteryPhaseMapper lotteryPhaseMapper, LotteryWinnerMapper lotteryWinnerMapper, LotteryPushService lotteryPushService, MerchantInfoFacadeService merchantInfoFacadeService, LocationIntegrationService locationIntegrationService) {
        this.joinStrategyManage = joinStrategyManage;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.activityProperties = activityProperties;
        this.userIntegrationService = userIntegrationService;
        this.lotteryPhaseService = lotteryPhaseService;
        this.lotteryWinnerService = lotteryWinnerService;
        this.lotteryPrizeService = lotteryPrizeService;
        this.lotteryAwardService = lotteryAwardService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.lotteryWinnerMapper = lotteryWinnerMapper;
        this.lotteryPushService = lotteryPushService;
        this.merchantInfoFacadeService = merchantInfoFacadeService;
        this.locationIntegrationService = locationIntegrationService;
    }
}

