/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryCounterMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryWinnerMapper;
import com.bxm.localnews.merchant.dto.activity.LotteryParticipatorDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseBaseInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseOverviewDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerCarouselDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerOverviewDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantLotteryAwardDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantLotteryCountDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryCountNumEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryCounterEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryPhaseEntity;
import com.bxm.localnews.merchant.param.activity.LotteryBasePageParam;
import com.bxm.localnews.merchant.param.activity.LotteryBaseParam;
import com.bxm.localnews.merchant.param.activity.LotteryMorePhaseParam;
import com.bxm.localnews.merchant.param.activity.LotteryParam;
import com.bxm.localnews.merchant.param.activity.LotteryParticipatorPageParam;
import com.bxm.localnews.merchant.param.activity.MerchantLotteryAwardCountParam;
import com.bxm.localnews.merchant.param.activity.MerchantLotteryAwardPageParam;
import com.bxm.localnews.merchant.service.enums.ActivityPrizeStatusEnum;
import com.bxm.localnews.merchant.service.enums.AwardTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryMerchantTabEnum;
import com.bxm.localnews.merchant.service.enums.LotteryPhaseStatusEnum;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.enums.UseStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryListCompositeService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryListCompositeServiceImpl
implements LotteryListCompositeService {
    private final LotteryMapper lotteryMapper;
    private final ActivityAwardMapper activityAwardMapper;
    private final LotteryCounterMapper lotteryCounterMapper;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final LotteryWinnerMapper lotteryWinnerMapper;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private final LotteryCacheManage lotteryCacheManage;

    public LotteryListCompositeServiceImpl(LotteryMapper lotteryMapper, LotteryCounterMapper lotteryCounterMapper, LotteryPhaseMapper lotteryPhaseMapper, LotteryCacheManage lotteryCacheManage, LotteryParticipatorMapper lotteryParticipatorMapper, LotteryWinnerMapper lotteryWinnerMapper, ActivityAwardMapper activityAwardMapper) {
        this.lotteryMapper = lotteryMapper;
        this.lotteryCounterMapper = lotteryCounterMapper;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.lotteryCacheManage = lotteryCacheManage;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.lotteryWinnerMapper = lotteryWinnerMapper;
        this.activityAwardMapper = activityAwardMapper;
    }

    @Override
    public PageWarper<MerchantLotteryAwardDTO> queryMerchantLotteryList(MerchantLotteryAwardPageParam param) {
        if (LotteryMerchantTabEnum.UNDERWAY.getCode().equals(param.getStatus()) || LotteryMerchantTabEnum.END.getCode().equals(param.getStatus())) {
            PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
            PageWarper merchantPhasePageInfo = new PageWarper(this.lotteryPhaseMapper.queryMerchantPhaseListByStatus(param));
            merchantPhasePageInfo.getList().forEach(item -> {
                LotteryCounterEntity lotteryCounterEntity;
                if (LotteryMerchantTabEnum.END.getCode().equals(param.getStatus())) {
                    this.convertMerchantPhaseItem((MerchantLotteryAwardDTO)item);
                }
                if ((lotteryCounterEntity = this.lotteryCounterMapper.countPhaseNum(item.getCurrentPhaseId())) == null) {
                    item.setFunsNum(Integer.valueOf(0));
                    item.setShowNum(Integer.valueOf(0));
                    item.setJoinNum(Integer.valueOf(0));
                } else {
                    item.setFunsNum(lotteryCounterEntity.getFunsNum());
                    item.setShowNum(lotteryCounterEntity.getShowNum());
                    item.setJoinNum(lotteryCounterEntity.getJoinNum());
                }
            });
            return merchantPhasePageInfo;
        }
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageWarper merchantLotteryAwardPageInfo = new PageWarper(this.lotteryMapper.queryMerchantLotteryListByStatus(param));
        merchantLotteryAwardPageInfo.getList().forEach(item -> {
            LotteryCountNumEntity lotteryCountNumEntity = this.lotteryCounterMapper.countLotteryNum(item.getLotteryId());
            if (lotteryCountNumEntity == null) {
                item.setFunsNum(Integer.valueOf(0));
                item.setShowNum(Integer.valueOf(0));
                item.setJoinNum(Integer.valueOf(0));
            } else {
                item.setFunsNum(lotteryCountNumEntity.getFunsNum());
                item.setShowNum(lotteryCountNumEntity.getShowNum());
                item.setJoinNum(lotteryCountNumEntity.getJoinNum());
            }
        });
        return merchantLotteryAwardPageInfo;
    }

    @Override
    public List<MerchantLotteryCountDTO> awardListCount(MerchantLotteryAwardCountParam param) {
        ArrayList<MerchantLotteryCountDTO> resultList = new ArrayList<MerchantLotteryCountDTO>();
        int startCount = this.lotteryPhaseMapper.queryMerchantPhaseCountByStatus(param.getAreaCode(), param.getMerchantId(), LotteryMerchantTabEnum.UNDERWAY.getCode());
        MerchantLotteryCountDTO startResult = new MerchantLotteryCountDTO();
        startResult.setStatus(LotteryMerchantTabEnum.UNDERWAY.getCode());
        startResult.setCount(Integer.valueOf(startCount));
        resultList.add(startResult);
        int notStartCount = this.lotteryMapper.queryMerchantLotteryCountByStatus(param.getAreaCode(), param.getMerchantId(), LotteryStatusEnum.UNDER_PLANNING.getCode());
        MerchantLotteryCountDTO notStartResult = new MerchantLotteryCountDTO();
        notStartResult.setStatus(LotteryMerchantTabEnum.NOT_START.getCode());
        notStartResult.setCount(Integer.valueOf(notStartCount));
        resultList.add(notStartResult);
        int offlineAndEndCount = this.lotteryPhaseMapper.queryMerchantPhaseCountByStatus(param.getAreaCode(), param.getMerchantId(), LotteryMerchantTabEnum.END.getCode());
        MerchantLotteryCountDTO endResult = new MerchantLotteryCountDTO();
        endResult.setStatus(LotteryMerchantTabEnum.END.getCode());
        endResult.setCount(Integer.valueOf(offlineAndEndCount));
        resultList.add(endResult);
        return resultList;
    }

    @Override
    public PageWarper<LotteryPhaseOverviewDTO> historyPublishList(LotteryParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageWarper historyPublishPhasePageInfo = new PageWarper(this.lotteryPhaseMapper.queryHistoryPublishList(param));
        this.fillJoinTimes(historyPublishPhasePageInfo.getList(), param.getUserId());
        for (LotteryPhaseOverviewDTO dto : historyPublishPhasePageInfo.getList()) {
            this.maskDtoPhone(dto);
        }
        return historyPublishPhasePageInfo;
    }

    @Override
    public PageWarper<LotteryPhaseOverviewDTO> underwayList(LotteryBasePageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageWarper underwayPageInfo = new PageWarper(this.lotteryPhaseMapper.queryUnderwayList(param));
        this.fillJoinTimes(underwayPageInfo.getList(), param.getUserId());
        return underwayPageInfo;
    }

    @Override
    public PageWarper<LotteryPhaseOverviewDTO> recentList(LotteryBasePageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        PageWarper recentPageInfo = new PageWarper(this.lotteryPhaseMapper.queryRecentList(param));
        this.fillJoinTimes(recentPageInfo.getList(), param.getUserId());
        for (LotteryPhaseOverviewDTO dto : recentPageInfo.getList()) {
            this.maskDtoPhone(dto);
        }
        return recentPageInfo;
    }

    @Override
    public List<LotteryPhaseOverviewDTO> historyList(LotteryParam param) {
        List historyList = this.lotteryPhaseMapper.queryHistoryList(param);
        for (LotteryPhaseOverviewDTO dto : historyList) {
            this.maskDtoPhone(dto);
        }
        return historyList;
    }

    @Override
    public PageWarper<LotteryPhaseOverviewDTO> myJoinPhaseList(LotteryBasePageParam param) {
        PageMethod.startPage((Object)param);
        PageWarper myJoinPhasePageInfo = new PageWarper(this.lotteryParticipatorMapper.queryMyJoinPhaseQueryList(param.getAreaCode(), param.getUserId()));
        this.fillJoinTimes(myJoinPhasePageInfo.getList(), param.getUserId());
        for (LotteryPhaseOverviewDTO dto : myJoinPhasePageInfo.getList()) {
            this.maskDtoPhone(dto);
        }
        return myJoinPhasePageInfo;
    }

    @Override
    public PageWarper<LotteryPhaseOverviewDTO> recommendList(LotteryMorePhaseParam param) {
        LotteryPhaseEntity phaseInfo;
        Long awardId;
        LotteryAwardEntityWithBLOBs awardInfo;
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        Long currentPhaseId = param.getPhaseId();
        if (currentPhaseId != null && (awardInfo = this.activityAwardMapper.selectByPrimaryKey(awardId = (phaseInfo = this.lotteryPhaseMapper.selectById(currentPhaseId)).getAwardId())) != null) {
            param.setMerchantId(awardInfo.getMerchantId());
        }
        return new PageWarper(this.lotteryPhaseMapper.queryMerchantPhaseList(param));
    }

    @Override
    public LotteryWinnerCarouselDTO lotteryCarousel(LotteryBaseParam param) {
        List recentWinnerInfoList = this.lotteryWinnerMapper.selectRecentWinnerInfo(param);
        int winnerNum = this.lotteryWinnerMapper.countWinner(param);
        LotteryWinnerCarouselDTO resultDTO = new LotteryWinnerCarouselDTO();
        resultDTO.setWinnerNum(Integer.valueOf(winnerNum));
        if (CollectionUtils.isEmpty((Collection)recentWinnerInfoList)) {
            resultDTO.setCarouselList(Collections.emptyList());
        } else {
            resultDTO.setCarouselList(recentWinnerInfoList);
        }
        return resultDTO;
    }

    @Override
    public PageWarper<LotteryParticipatorDTO> joinRecordList(LotteryParticipatorPageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        return new PageWarper(this.lotteryParticipatorMapper.joinRecordList(param));
    }

    @Override
    public PageWarper<LotteryWinnerOverviewDTO> myWinnerPhaseList(LotteryBasePageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        return new PageWarper(this.lotteryWinnerMapper.myWinnerPhaseList(param));
    }

    @Override
    public List<LotteryWinnerInfoDTO> queryWinnerList(LotteryBaseParam param) {
        return this.lotteryWinnerMapper.queryWinnerList(param);
    }

    public void fillJoinTimes(List<LotteryPhaseOverviewDTO> phaseOverviewDTOList, Long currentUserId) {
        List<Long> phaseIds = phaseOverviewDTOList.stream().map(LotteryPhaseBaseInfoDTO::getPhaseId).collect(Collectors.toList());
        Map<Long, List<String>> myCodes = this.lotteryCacheManage.getMyCodes(phaseIds, currentUserId);
        phaseOverviewDTOList.forEach(item -> {
            if (myCodes != null && myCodes.get(item.getPhaseId()) != null) {
                List codeList = (List)myCodes.get(item.getPhaseId());
                item.setJoinTimes(Integer.valueOf(codeList.size()));
            } else {
                item.setJoinTimes(Integer.valueOf(0));
            }
        });
    }

    private void convertMerchantPhaseItem(MerchantLotteryAwardDTO item) {
        if (LotteryPhaseStatusEnum.CANCEL.getCode().equals(item.getStatus())) {
            item.setUseStatus(Integer.valueOf(UseStatusEnum.OFFLINE.getCode()));
        } else if (AwardTypeEnum.GOODS.getCode().equals(item.getType())) {
            if (ActivityPrizeStatusEnum.CHECKED.getCode().equals(item.getCheckStatus())) {
                item.setUseStatus(Integer.valueOf(UseStatusEnum.HAVE_CHECK.getCode()));
            } else {
                item.setUseStatus(Integer.valueOf(UseStatusEnum.NOT_CHECK.getCode()));
            }
        } else if (ActivityPrizeStatusEnum.GRANT.getCode().equals(item.getCheckStatus())) {
            item.setUseStatus(Integer.valueOf(UseStatusEnum.HAVE_AWARD.getCode()));
        } else if (ActivityPrizeStatusEnum.UN_GRANT.getCode().equals(item.getAwardStatus())) {
            item.setUseStatus(Integer.valueOf(UseStatusEnum.NOT_AWARD.getCode()));
        }
    }

    private void maskDtoPhone(LotteryPhaseOverviewDTO phaseDTO) {
        LotteryWinnerInfoDTO winnerInfoDTO;
        if (phaseDTO.getWinner() != null && StringUtils.isNotBlank((CharSequence)(winnerInfoDTO = phaseDTO.getWinner()).getPhone())) {
            winnerInfoDTO.setPhone(com.bxm.newidea.component.tools.StringUtils.hideMobile((String)winnerInfoDTO.getPhone()));
        }
    }
}

