/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.merchant.coupon.facade.service.CouponFacadeService;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.ImCouponDTO;
import com.bxm.localnews.merchant.dto.activity.ImGroupProductDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryMerchantInfoDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantGoodsListDTO;
import com.bxm.localnews.merchant.dto.activity.MerchantLastPhaseDTO;
import com.bxm.localnews.merchant.entity.coupon.MerchantCouponInfoEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryPhaseEntity;
import com.bxm.localnews.merchant.integration.BizLogIntegrationService;
import com.bxm.localnews.merchant.integration.ImIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.BatchMessageParam;
import com.bxm.localnews.merchant.param.activity.LotteryMerchantFollowParam;
import com.bxm.localnews.merchant.service.enums.WelfareTypeEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryMerchantService;
import com.bxm.localnews.merchant.service.lottery.LotteryStatisticsService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.localnews.merchant.service.lottery.event.LotteryFollowEvent;
import com.bxm.localnews.merchant.utils.GoodsPriceRelatedUtils;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LotteryMerchantServiceImpl
implements LotteryMerchantService {
    private static final Logger log = LoggerFactory.getLogger(LotteryMerchantServiceImpl.class);
    private final ActivityAwardMapper activityAwardMapper;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final UserIntegrationService userIntegrationService;
    private final MerchantInfoFacadeService merchantInfoFacadeService;
    private final ImIntegrationService imIntegrationService;
    private final CouponFacadeService couponInfoService;
    private final LotteryCacheManage lotteryCacheManage;
    private final LotteryStatisticsService lotteryStatisticsService;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final MerchantGoodsMapper merchantGoodsMapper;

    @Autowired
    public LotteryMerchantServiceImpl(UserIntegrationService userIntegrationService, MerchantInfoFacadeService merchantInfoFacadeService, ImIntegrationService imIntegrationService, LotteryPhaseMapper lotteryPhaseMapper, ActivityAwardMapper activityAwardMapper, CouponFacadeService couponInfoService, LotteryCacheManage lotteryCacheManage, LotteryStatisticsService lotteryStatisticsService, BizLogIntegrationService bizLogIntegrationService, MerchantGoodsMapper merchantGoodsMapper) {
        this.userIntegrationService = userIntegrationService;
        this.merchantInfoFacadeService = merchantInfoFacadeService;
        this.imIntegrationService = imIntegrationService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.activityAwardMapper = activityAwardMapper;
        this.couponInfoService = couponInfoService;
        this.lotteryStatisticsService = lotteryStatisticsService;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.lotteryCacheManage = lotteryCacheManage;
        this.merchantGoodsMapper = merchantGoodsMapper;
    }

    @Override
    @Async
    public void execAsyncFollow(LotteryMerchantFollowParam param) {
        if (Objects.equals(param.getMerchantUserId(), param.getUserId())) {
            return;
        }
        MerchantInfo merchantInfoFrom = this.merchantInfoFacadeService.getMerchantInfo(param.getMerchantUserId());
        if (Objects.nonNull(merchantInfoFrom)) {
            param.setMerchantUserId(merchantInfoFrom.getUserId());
        }
        this.userIntegrationService.follow(param.getUserId(), param.getMerchantUserId());
        Long phaseId = param.getPhaseId();
        LotteryPhaseEntity lotteryPhaseEntity = this.lotteryPhaseMapper.selectById(phaseId);
        if (lotteryPhaseEntity == null) {
            log.warn("\u5f53\u524d\u671f\u6570\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)param);
            return;
        }
        this.lotteryStatisticsService.post(new LotteryFollowEvent(lotteryPhaseEntity.getLotteryId(), lotteryPhaseEntity.getId()));
        this.bizLogIntegrationService.point(PointReportParam.build().e("3034").ev("129." + param.getPhaseId()).put("uid", String.valueOf(param.getMerchantUserId())));
        LotteryAwardEntityWithBLOBs awardInfo = this.activityAwardMapper.selectByPrimaryKey(lotteryPhaseEntity.getAwardId());
        Long merchantId = awardInfo.getMerchantId();
        MerchantInfo merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(merchantId);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)awardInfo.getReplayContent())) {
            this.sendFollowMsg(param.getMerchantUserId(), param.getUserId(), awardInfo.getReplayContent());
        }
        if (Objects.equals(awardInfo.getWelfareType(), WelfareTypeEnum.NO_WELFARE.getType())) {
            return;
        }
        if (Objects.equals(awardInfo.getWelfareType(), WelfareTypeEnum.COUPON.getType())) {
            Long couponId = Long.valueOf(awardInfo.getWelfareId());
            if (Boolean.FALSE.equals(this.lotteryCacheManage.hasFollowGrantCoupon(param.getUserId(), couponId))) {
                this.sendCouponMsg(param.getUserId(), couponId, merchantInfo);
            }
        }
        if (Objects.equals(awardInfo.getWelfareType(), WelfareTypeEnum.GROUP_BUY.getType())) {
            this.sendGroupBuyMsg(param.getUserId(), Long.valueOf(awardInfo.getWelfareId()), merchantInfo);
        }
    }

    private void sendGroupBuyMsg(Long userId, Long goodsId, MerchantInfo merchantInfo) {
        ImGroupProductDTO imGroupProductDTO = this.fixGroupProductInfo(goodsId);
        BatchMessageParam messageParam = new BatchMessageParam();
        messageParam.setContent(JSON.toJSONString((Object)imGroupProductDTO));
        messageParam.setObjectName("LN:GroupProduct");
        messageParam.setFromUserId(merchantInfo.getUserId());
        messageParam.setToUserId(Collections.singletonList(userId));
        this.imIntegrationService.sendMsg(messageParam);
    }

    private ImGroupProductDTO fixGroupProductInfo(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.getGoodsInfoById(goodsId);
        if (merchantGoodsVo == null) {
            return ImGroupProductDTO.builder().build();
        }
        BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice((BigDecimal)merchantGoodsVo.getPrice(), (Integer)merchantGoodsVo.getVipDiscount());
        BigDecimal discount = GoodsPriceRelatedUtils.getDiscount((BigDecimal)merchantGoodsVo.getPrice(), (Integer)merchantGoodsVo.getVipDiscount(), (BigDecimal)merchantGoodsVo.getOriginalPrice(), (BigDecimal)vipPrice);
        String firstImg = this.getFirstImg(merchantGoodsVo.getHeadPics());
        return ImGroupProductDTO.builder().imgUrl(firstImg).title(merchantGoodsVo.getName()).price(merchantGoodsVo.getOriginalPrice().toString()).productId(goodsId.toString()).realPrice(vipPrice.toString()).tag(discount.stripTrailingZeros().toPlainString() + "\u6298").build();
    }

    private void sendCouponMsg(Long toUserId, Long couponId, MerchantInfo merchantInfo) {
        ImCouponDTO couponDTO = this.fillCouponImMsg(merchantInfo, couponId);
        BatchMessageParam messageParam = new BatchMessageParam();
        messageParam.setContent(JSON.toJSONString((Object)couponDTO));
        messageParam.setObjectName("LN:Coupon");
        messageParam.setFromUserId(merchantInfo.getUserId());
        messageParam.setToUserId(Collections.singletonList(toUserId));
        this.lotteryCacheManage.followGrantUserCoupon(toUserId, couponId);
        this.imIntegrationService.sendMsg(messageParam);
    }

    private void sendFollowMsg(Long merchantUserId, Long userId, String replyContent) {
        BatchMessageParam messageParam = new BatchMessageParam();
        messageParam.setContent(replyContent);
        messageParam.setObjectName("RC:TxtMsg");
        messageParam.setFromUserId(merchantUserId);
        messageParam.setToUserId(Collections.singletonList(userId));
        this.imIntegrationService.sendMsg(messageParam);
    }

    private ImCouponDTO fillCouponImMsg(MerchantInfo merchantInfo, Long couponId) {
        BigDecimal totalAmount;
        Integer conditionAmount;
        MerchantCouponInfoEntity couponDetail = this.couponInfoService.getCouponDetail(couponId);
        if (couponDetail == null) {
            log.warn("\u5f53\u524d\u4f18\u60e0\u5238\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)couponId);
            return new ImCouponDTO();
        }
        ImCouponDTO couponMsg = new ImCouponDTO();
        couponMsg.setCouponId(couponId);
        BigDecimal discount = couponDetail.getDiscount();
        if (Objects.nonNull(discount)) {
            couponMsg.setAmount(discount.setScale(2, 1));
        }
        if ((conditionAmount = couponDetail.getConditionAmount()) == 0) {
            couponMsg.setLimit("\u65e0\u95e8\u69db");
        } else if (conditionAmount == 1 && Objects.nonNull(totalAmount = couponDetail.getTotalAmount())) {
            couponMsg.setLimit(String.format("\u6ee1%s\u5143\u53ef\u7528", totalAmount.setScale(2, 1)));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date usableStartTime = couponDetail.getUsableStartTime();
        Date usableEndTime = couponDetail.getUsableEndTime();
        String usableDate = sdf.format(usableStartTime) + "-" + sdf.format(usableEndTime);
        couponMsg.setDate(usableDate);
        couponMsg.setStore(merchantInfo.getMerchantName());
        return couponMsg;
    }

    @Override
    public LotteryMerchantInfoDTO get(Long merchantId) {
        LotteryMerchantInfoDTO resultDTO = new LotteryMerchantInfoDTO();
        MerchantInfo merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(merchantId);
        if (Objects.nonNull(merchantInfo)) {
            this.convert2LotteryMerchantInfoDTO(merchantInfo, resultDTO);
        }
        return resultDTO;
    }

    @Override
    public LotteryMerchantInfoDTO get(Long merchantId, Long currentUserId) {
        LotteryMerchantInfoDTO resultDTO = this.get(merchantId);
        if (null != currentUserId) {
            resultDTO.setFollow(this.userIntegrationService.isFollow(currentUserId, resultDTO.getMerchantUserId()));
        }
        return resultDTO;
    }

    @Override
    public MerchantLastPhaseDTO getMerchantHasProceedPhase(Long merchantId) {
        return this.lotteryPhaseMapper.queryMerchantLastProceedPhaseId(merchantId);
    }

    private void convert2LotteryMerchantInfoDTO(MerchantInfo merchantInfo, LotteryMerchantInfoDTO resultDTO) {
        resultDTO.setMerchantId(merchantInfo.getId());
        resultDTO.setMerchantName(merchantInfo.getMerchantName());
        resultDTO.setAddress(merchantInfo.getAddress());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)merchantInfo.getLogo())) {
            resultDTO.setLogoImg(merchantInfo.getLogo());
        } else {
            String headPics = merchantInfo.getHeadPics();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)headPics)) {
                String[] firstHeadPic = headPics.split(",");
                resultDTO.setLogoImg(firstHeadPic[0]);
            }
        }
        resultDTO.setDescription(merchantInfo.getDes());
        resultDTO.setMerchantUserId(merchantInfo.getUserId());
        UserInfoDTO userCache = this.userIntegrationService.getUserFromRedisDB(merchantInfo.getUserId());
        if (userCache != null) {
            resultDTO.setMerchantUserHeadImg(userCache.getHeadImg());
            resultDTO.setMerchantUserName(userCache.getNickname());
        }
        resultDTO.setLat(merchantInfo.getLat());
        resultDTO.setLng(merchantInfo.getLng());
    }

    @Override
    public List<MerchantGoodsListDTO> getMerchantGoods(Long merchantId) {
        List merchantGoodsVos = this.merchantGoodsMapper.selectByMerchantId(merchantId, Integer.valueOf(2));
        return merchantGoodsVos.stream().map(merchantGoodsVo -> {
            MerchantGoodsListDTO goodsListDTO = new MerchantGoodsListDTO();
            if (Objects.nonNull(merchantGoodsVo)) {
                BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)goodsListDTO);
                if (StringUtils.isNotBlank((String)merchantGoodsVo.getHeadPics())) {
                    goodsListDTO.setImg(this.getFirstImg(merchantGoodsVo.getHeadPics()));
                }
                BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice((BigDecimal)merchantGoodsVo.getPrice(), (Integer)goodsListDTO.getVipDiscount());
                BigDecimal discount = GoodsPriceRelatedUtils.getDiscount((BigDecimal)merchantGoodsVo.getPrice(), (Integer)goodsListDTO.getVipDiscount(), (BigDecimal)merchantGoodsVo.getOriginalPrice(), (BigDecimal)vipPrice);
                goodsListDTO.setVipPrice(vipPrice);
                goodsListDTO.setVipDiscount(merchantGoodsVo.getVipDiscount());
                goodsListDTO.setDiscount(discount);
                goodsListDTO.setGoodsId(merchantGoodsVo.getId());
                goodsListDTO.setGazePeopleNum(merchantGoodsVo.getGazePeopleNum());
            }
            return goodsListDTO;
        }).collect(Collectors.toList());
    }

    private String getFirstImg(String goodsImg) {
        String[] imgs;
        if (StringUtils.isNotBlank((String)goodsImg) && goodsImg.contains(",") && (imgs = goodsImg.split(",")).length > 0) {
            return imgs[0];
        }
        return goodsImg;
    }
}

