/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinStateDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryAddVirtualParam;
import com.bxm.localnews.merchant.param.activity.LotteryCheckJoinTimesParam;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryParticipatorService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.strategy.JoinStrategyManage;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LotteryParticipatorServiceImpl
implements LotteryParticipatorService {
    private static final Logger log = LoggerFactory.getLogger(LotteryParticipatorServiceImpl.class);
    private final JoinStrategyManage joinStrategyManage;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private final SequenceCreater sequenceCreater;
    private final LotteryCacheManage lotteryCacheManage;
    private final UserIntegrationService userIntegrationService;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final ActivityProperties activityProperties;

    @Autowired
    public LotteryParticipatorServiceImpl(JoinStrategyManage joinStrategyManage, LotteryParticipatorMapper lotteryParticipatorMapper, SequenceCreater sequenceCreater, LotteryCacheManage lotteryCacheManage, UserIntegrationService userIntegrationService, LotteryPhaseMapper lotteryPhaseMapper, RedisStringAdapter redisStringAdapter, ActivityProperties activityProperties) {
        this.joinStrategyManage = joinStrategyManage;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.sequenceCreater = sequenceCreater;
        this.lotteryCacheManage = lotteryCacheManage;
        this.userIntegrationService = userIntegrationService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.activityProperties = activityProperties;
    }

    @Override
    public LotteryJoinResultDTO join(LotteryPhaseJoinParam param) {
        return this.joinStrategyManage.execute(LotteryJoinContext.builder().param(param).build());
    }

    @Override
    public Message save(LotteryParticipatorEntity entity) {
        entity.setId(this.sequenceCreater.nextLongId());
        return Message.build((int)this.lotteryParticipatorMapper.insert(entity));
    }

    @Override
    public int countUserType(Long phaseId, LotteryUserTypeEnum userType) {
        return this.lotteryParticipatorMapper.countUserType(phaseId, userType.getCode());
    }

    @Override
    public void addVirtual(Long phaseId) {
        List<LotteryParticipatorEntity> virtualUsers;
        KeyGenerator key = RedisConfig.LOTTERY_TEMP_VIRTUAL_KEY.copy().appendKey((Object)phaseId).appendKey((Object)this.getHalfHourKey());
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            TypeReference<List<LotteryParticipatorEntity>> typeReference = new TypeReference<List<LotteryParticipatorEntity>>(){};
            virtualUsers = (List<LotteryParticipatorEntity>)this.redisStringAdapter.get(key, (TypeReference)typeReference);
        } else {
            int currentMin = 30 - LocalDateTime.now().getMinute() % 30;
            int randomNum = RandomUtils.nextInt((int)(this.activityProperties.getHalfHourMinNum() * currentMin / 30), (int)(this.activityProperties.getHalfHourMaxNum() * currentMin / 30));
            if (randomNum < 1) {
                randomNum = 1;
            }
            List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(randomNum));
            virtualUsers = virtualUserList.stream().map(user -> LotteryParticipatorEntity.builder().createTime(this.getRandomDate()).headImg(user.getHeadImg()).nickName(user.getNickname()).userId(user.getId()).build()).collect(Collectors.toList());
            virtualUsers.sort((u1, u2) -> (int)(u1.getCreateTime().getTime() - u2.getCreateTime().getTime()));
            this.redisStringAdapter.set(key, virtualUsers, 1800L);
        }
        ArrayList afterJoin = Lists.newArrayList();
        afterJoin.addAll(virtualUsers);
        virtualUsers.forEach(user -> {
            if (DateUtils.before((Date)user.getCreateTime())) {
                this.addVirtualJoin(user.getUserId(), phaseId, null, false);
                afterJoin.remove(user);
            }
        });
        this.redisStringAdapter.set(key, (Object)afterJoin, 1800L);
    }

    @Override
    public void addVirtual(LotteryAddVirtualParam param) {
        if (null == param.getNum() || null == param.getPhaseId()) {
            return;
        }
        List virtualUserList = this.userIntegrationService.getVirtualUserList(param.getNum());
        int seconds = 1;
        for (UserInfoDTO userInfoDTO : virtualUserList) {
            Date createTime = new Date();
            createTime = DateUtils.addField((Date)createTime, (int)13, (int)seconds);
            createTime = DateUtils.addField((Date)createTime, (int)14, (int)RandomUtils.nextInt((int)0, (int)1000));
            this.addVirtualJoin(userInfoDTO.getId(), param.getPhaseId(), createTime, true);
            seconds += RandomUtils.nextInt((int)1, (int)param.getSeconds());
        }
    }

    private void addVirtualJoin(Long userId, Long phaseId, Date createTime, Boolean skipLimit) {
        LotteryPhaseJoinParam param = new LotteryPhaseJoinParam();
        param.setUserId(userId);
        param.setPhaseId(phaseId);
        if (createTime == null) {
            createTime = new Date();
        }
        DateUtils.setField((Date)createTime, (int)14, (int)RandomUtils.nextInt((int)0, (int)1000));
        LotteryJoinContext joinContext = LotteryJoinContext.builder().param(param).joinSource(LotteryJoinSourceEnum.VIRTUAL).joinTime(createTime).skipActualLimit(skipLimit).build();
        this.joinStrategyManage.execute(joinContext);
    }

    private Date getRandomDate() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        Calendar afterHalfHour = Calendar.getInstance();
        afterHalfHour.setTime(now);
        afterHalfHour.set(13, 0);
        afterHalfHour.set(14, 0);
        int minute = afterHalfHour.get(12);
        if (minute >= 30) {
            afterHalfHour.set(12, 0);
            afterHalfHour.add(10, 1);
        } else {
            afterHalfHour.set(12, 30);
        }
        int diffMillSeconds = (int)(afterHalfHour.getTimeInMillis() - calendar.getTimeInMillis());
        calendar.add(14, RandomUtils.nextInt((int)0, (int)diffMillSeconds));
        return calendar.getTime();
    }

    private String getHalfHourKey() {
        LocalDateTime now = LocalDateTime.now();
        int minute = now.getMinute();
        String key = now.getDayOfMonth() + "" + now.getHour();
        key = minute >= 30 ? key + "30" : key + "00";
        return key;
    }

    @Override
    public LotteryJoinStateDTO getJoinInfo(LotteryCheckJoinTimesParam param) {
        LotteryJoinStateDTO stateDTO = new LotteryJoinStateDTO();
        stateDTO.setNewbie(Boolean.valueOf(false));
        stateDTO.setFree(Boolean.valueOf(false));
        if (Objects.equals(PlatformEnum.WEB.getCode(), param.getPlatform())) {
            if (this.lotteryCacheManage.hasGlobalJoinTimes(param.getUserId()).booleanValue()) {
                stateDTO.setJoinTimes(Integer.valueOf(1));
            } else {
                stateDTO.setJoinTimes(Integer.valueOf(0));
            }
            stateDTO.setFree(Boolean.valueOf(true));
        } else {
            stateDTO.setNewbie(Boolean.valueOf(this.isNewbie(param)));
            if (stateDTO.getNewbie().booleanValue()) {
                stateDTO.setFree(this.lotteryCacheManage.hasFreeJoinTime(param.getUserId()));
            }
            this.setMaxTimesAndMaxType(param);
            stateDTO.setJoinTimes(Integer.valueOf((int)((long)param.getMaxTimes().intValue() - this.lotteryCacheManage.getAppJoinTimes(param.getPhaseId(), param.getUserId(), param.getMaxType()))));
        }
        return stateDTO;
    }

    private void setMaxTimesAndMaxType(LotteryCheckJoinTimesParam param) {
        if (null == param.getMaxTimes() || Objects.isNull(param.getMaxType())) {
            LotteryPhaseCoreInfoDTO phaseInfo = this.lotteryPhaseMapper.getCorePhaseInfo(param.getPhaseId());
            param.setMaxTimes(phaseInfo.getMaxTimes());
            param.setMaxType(phaseInfo.getMaxType());
        }
    }

    private boolean isNewbie(LotteryCheckJoinTimesParam param) {
        Date userCreateTime = param.getUserCreateTime();
        if (userCreateTime == null) {
            UserInfoDTO cacheUser = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            userCreateTime = cacheUser.getCreateTime();
        }
        return DateUtils.isSameDay((Date)userCreateTime, (Date)new Date());
    }
}

