/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryCoreInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotterySharePosterDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryPhaseEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryChangeStatusParam;
import com.bxm.localnews.merchant.param.activity.LotteryPhasePosterDetailParam;
import com.bxm.localnews.merchant.service.enums.LotteryPhaseStatusEnum;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryAwardService;
import com.bxm.localnews.merchant.service.lottery.LotteryParticipatorService;
import com.bxm.localnews.merchant.service.lottery.LotteryPhaseService;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.localnews.merchant.service.lottery.LotteryService;
import com.bxm.localnews.merchant.service.lottery.LotteryStatisticsService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LotteryPhaseServiceImpl
implements LotteryPhaseService {
    private static final Logger log = LoggerFactory.getLogger(LotteryPhaseServiceImpl.class);
    private final LotteryAwardService lotteryAwardService;
    private LotteryService lotteryService;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final SequenceCreater sequenceCreater;
    private final LotteryCacheManage lotteryCacheManage;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private final ActivityAwardMapper activityAwardMapper;
    private final LotteryMapper lotteryMapper;
    private final LotteryParticipatorService lotteryParticipatorService;
    private final MerchantInfoFacadeService merchantInfoFacadeService;
    private final UserIntegrationService userIntegrationService;
    private final LocationIntegrationService locationIntegrationService;
    private final LotteryPushService lotteryPushService;
    private final LotteryStatisticsService lotteryStatisticsService;

    @Autowired
    public LotteryPhaseServiceImpl(LotteryAwardService lotteryAwardService, LotteryPhaseMapper lotteryPhaseMapper, SequenceCreater sequenceCreater, LotteryCacheManage lotteryCacheManage, LotteryParticipatorMapper lotteryParticipatorMapper, LotteryParticipatorService lotteryParticipatorService, ActivityAwardMapper activityAwardMapper, MerchantInfoFacadeService merchantInfoFacadeService, UserIntegrationService userIntegrationService, LotteryMapper lotteryMapper, LocationIntegrationService locationIntegrationService, LotteryPushService lotteryPushService, LotteryStatisticsService lotteryStatisticsService) {
        this.lotteryAwardService = lotteryAwardService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.sequenceCreater = sequenceCreater;
        this.lotteryCacheManage = lotteryCacheManage;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.lotteryParticipatorService = lotteryParticipatorService;
        this.activityAwardMapper = activityAwardMapper;
        this.merchantInfoFacadeService = merchantInfoFacadeService;
        this.userIntegrationService = userIntegrationService;
        this.lotteryMapper = lotteryMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.lotteryPushService = lotteryPushService;
        this.lotteryStatisticsService = lotteryStatisticsService;
    }

    private LotteryService getLotteryService() {
        if (null == this.lotteryService) {
            this.lotteryService = (LotteryService)SpringContextHolder.getBean(LotteryService.class);
        }
        return this.lotteryService;
    }

    @Override
    public Message create(Long lotteryId) {
        MerchantInfo merchantInfo;
        log.info("\u6d3b\u52a8[{}]\u5f00\u542f\u65b0\u4e00\u671f\u7684\u593a\u5b9d\u6d3b\u52a8", (Object)lotteryId);
        LotteryCoreInfoDTO detailDTO = this.lotteryMapper.getLotteryInfo(lotteryId);
        if (!Objects.equals(detailDTO.getStatus(), LotteryStatusEnum.ACTIVED.getCode())) {
            log.info("[{}]\u6d3b\u52a8\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u5f00\u542f\u4e0b\u4e00\u671f\u6d3b\u52a8", (Object)lotteryId);
            return Message.build((boolean)false, (String)"\u6d3b\u52a8\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u5f00\u542f\u6d3b\u52a8");
        }
        if (detailDTO.getMerchantId() != null && !Objects.equals((merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(detailDTO.getMerchantId())).getIsShelf(), 1)) {
            log.info("\u6d3b\u52a8[{}]\u5bf9\u5e94\u7684\u5546\u5bb6[{}]\u4e0d\u5904\u4e8e\u4e0a\u67b6\u72b6\u6001", (Object)lotteryId, (Object)detailDTO.getMerchantId());
            LotteryChangeStatusParam changeParam = new LotteryChangeStatusParam();
            changeParam.setLotteryId(lotteryId);
            changeParam.setEnable(Boolean.valueOf(false));
            this.getLotteryService().changeStatus(changeParam, LotteryStatusEnum.MERCHANT_OFFLINE);
            return Message.build((boolean)false, (String)"\u5546\u5bb6\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u5f00\u542f\u6d3b\u52a8");
        }
        Long phaseId = this.sequenceCreater.nextLongId();
        Integer currentPhaseNum = detailDTO.getCurrentPhaseNum() + 1;
        Message message = this.lotteryAwardService.changeStock(detailDTO.getAwardId(), -1);
        if (message.isSuccess()) {
            this.getLotteryService().setLastPhase(lotteryId, phaseId, currentPhaseNum);
            this.saveNewPhase(detailDTO, phaseId, currentPhaseNum);
            this.lotteryPhaseMapper.updateLastPhaseId(lotteryId, phaseId);
            this.afterCreate(detailDTO, phaseId, currentPhaseNum);
        }
        log.info("\u6d3b\u52a8[{}]\u5f00\u542f\u7ed3\u679c\uff1a{}", (Object)lotteryId, (Object)message);
        return message;
    }

    private void afterCreate(LotteryCoreInfoDTO detailDTO, Long phaseId, Integer currentPhaseNum) {
        if (Objects.equals(detailDTO.getVirtualFlag(), 1)) {
            this.lotteryParticipatorService.addVirtual(phaseId);
        }
        if (detailDTO.getMerchantUserId() != null) {
            this.lotteryPushService.startPhase(detailDTO.getMerchantUserId(), currentPhaseNum, phaseId, detailDTO.getLotteryId());
        }
        this.lotteryStatisticsService.setup(detailDTO.getLotteryId(), phaseId);
    }

    private void saveNewPhase(LotteryCoreInfoDTO detailDTO, Long phaseId, Integer currentPhaseNum) {
        LotteryPhaseEntity entity = new LotteryPhaseEntity();
        entity.setId(phaseId);
        entity.setStatus(LotteryPhaseStatusEnum.GOING.getCode());
        entity.setLotteryId(detailDTO.getLotteryId());
        entity.setAwardId(detailDTO.getAwardId());
        entity.setCreateTime(new Date());
        entity.setTargetNum(detailDTO.getTargetNum());
        entity.setCurrentNum(Integer.valueOf(0));
        entity.setPhaseNum(currentPhaseNum);
        this.lotteryPhaseMapper.insert(entity);
    }

    @Override
    public Message cancel(Long lotteryId, Long phaseId, boolean focus) {
        log.info("\u6d3b\u52a8[{}]\u7684[{}]\u4e0b\u67b6", (Object)lotteryId, (Object)phaseId);
        if (!focus && this.lotteryParticipatorMapper.countUserType(phaseId, LotteryUserTypeEnum.ACTURAL.getCode()) > 0) {
            log.info("\u6d3b\u52a8[{}]-[{}]\u6709\u771f\u5b9e\u7528\u6237\u53c2\u4e0e\uff0c\u65e0\u6cd5\u53d6\u6d88", (Object)lotteryId, (Object)phaseId);
            return Message.build((boolean)false, (String)"\u6d3b\u52a8\u6709\u771f\u5b9e\u7528\u6237\u53c2\u4e0e\uff0c\u65e0\u6cd5\u53d6\u6d88");
        }
        this.lotteryPhaseMapper.updateStatus(phaseId, LotteryPhaseStatusEnum.CANCEL.getCode());
        this.lotteryPhaseMapper.updateLastPhaseId(lotteryId, null);
        return Message.build();
    }

    @Override
    public Message close(Long lotteryId, Long phaseId) {
        log.info("\u6d3b\u52a8[{}]\u7684[{}]\u5b8c\u6210\u5f00\u5956", (Object)lotteryId, (Object)phaseId);
        LotteryCoreInfoDTO lotteryInfo = this.lotteryMapper.getLotteryInfo(lotteryId);
        this.getLotteryService().setLastPhase(lotteryId, null, null);
        this.lotteryPhaseMapper.updateLastPhaseId(lotteryId, null);
        this.lotteryPhaseMapper.updateStatus(phaseId, LotteryPhaseStatusEnum.FINISH.getCode());
        this.lotteryCacheManage.clearPhaseCache(phaseId);
        if (null != lotteryInfo.getMerchantUserId()) {
            this.lotteryPushService.finishPhase(lotteryInfo.getMerchantId(), lotteryInfo.getMerchantUserId(), lotteryInfo.getCurrentPhaseNum());
        }
        return Message.build();
    }

    @Override
    public Message resume(Long lotteryId, Long phaseId) {
        log.info("\u6d3b\u52a8[{}]\u7684[{}]\u91cd\u65b0\u5f00\u542f", (Object)lotteryId, (Object)phaseId);
        this.lotteryPhaseMapper.updateStatus(phaseId, LotteryPhaseStatusEnum.GOING.getCode());
        this.lotteryPhaseMapper.updateLastPhaseId(lotteryId, phaseId);
        return Message.build();
    }

    @Override
    public LotterySharePosterDTO getSharePosterInfo(LotteryPhasePosterDetailParam param) {
        LotteryPhaseEntity lotteryPhaseEntity = this.lotteryPhaseMapper.selectById(param.getPhaseId());
        if (lotteryPhaseEntity == null) {
            return new LotterySharePosterDTO();
        }
        LotterySharePosterDTO resultDTO = new LotterySharePosterDTO();
        resultDTO.setLotteryId(lotteryPhaseEntity.getLotteryId());
        resultDTO.setPhaseId(lotteryPhaseEntity.getId());
        resultDTO.setTargetNum(lotteryPhaseEntity.getTargetNum());
        Long lotteryId = lotteryPhaseEntity.getLotteryId();
        LotteryEntity lotteryEntity = this.lotteryMapper.selectByPrimaryKey(lotteryId);
        resultDTO.setTitle(lotteryEntity.getTitle());
        Long awardId = lotteryPhaseEntity.getAwardId();
        LotteryAwardEntityWithBLOBs lotteryAwardEntity = this.activityAwardMapper.selectByPrimaryKey(awardId);
        resultDTO.setPrice(lotteryAwardEntity.getPrice());
        resultDTO.setImg(lotteryAwardEntity.getFirstImg());
        Long merchantId = lotteryAwardEntity.getMerchantId();
        if (merchantId != null) {
            MerchantInfo merchantInfo = this.merchantInfoFacadeService.getMerchantInfo(merchantId);
            resultDTO.setAddress(merchantInfo.getAddress());
        } else {
            LocationDTO locationInfo = this.locationIntegrationService.getLocationByGeocode(param.getAreaCode());
            if (locationInfo != null) {
                resultDTO.setAddress(locationInfo.getName());
            }
        }
        Long currentUserId = param.getUserId();
        UserInfoDTO shareUser = this.userIntegrationService.getUserFromRedisDB(currentUserId);
        if (shareUser != null) {
            resultDTO.setUserId(currentUserId);
            resultDTO.setNickName(shareUser.getNickname());
            resultDTO.setHeadImg(shareUser.getHeadImg());
        }
        return resultDTO;
    }
}

