/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.service.VerificationCodeService;
import com.bxm.localnews.merchant.domain.lottery.ActivityPrizeMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryWinnerMapper;
import com.bxm.localnews.merchant.dto.activity.ActivityPrizeInfoDTO;
import com.bxm.localnews.merchant.dto.activity.ActivityPrizeManageDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryCheckResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerManageDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityPrizeEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryWinnerEntity;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryPrizeCheckParam;
import com.bxm.localnews.merchant.param.activity.LotteryPrizeParam;
import com.bxm.localnews.merchant.param.activity.LotteryWinnerManagePageParam;
import com.bxm.localnews.merchant.service.enums.ActivityPrizeStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryPrizeService;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.page.PageMethod;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LotteryPrizeServiceImpl
implements LotteryPrizeService {
    private static final Logger log = LoggerFactory.getLogger(LotteryPrizeServiceImpl.class);
    @Resource
    private ActivityPrizeMapper activityPrizeMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private VerificationCodeService verificationCodeService;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private LotteryPushService lotteryPushService;
    @Resource
    private LotteryPhaseMapper lotteryPhaseMapper;
    @Resource
    private LotteryWinnerMapper lotteryWinnerMapper;

    @Override
    public PageWarper<LotteryWinnerManageDTO> selectByPage(LotteryWinnerManagePageParam param) {
        PageMethod.startPage((int)param.getPageNum(), (int)param.getPageSize());
        return new PageWarper(this.activityPrizeMapper.selectByPage(param));
    }

    @Override
    public ActivityPrizeManageDTO getPrizeDetail(Long prizeId) {
        ActivityPrizeEntity activityPrizeEntity = this.activityPrizeMapper.selectByPrimaryKey(prizeId);
        ActivityPrizeManageDTO detailInfo = new ActivityPrizeManageDTO();
        BeanUtils.copyProperties((Object)activityPrizeEntity, (Object)detailInfo);
        detailInfo.setPrizeId(activityPrizeEntity.getId());
        return detailInfo;
    }

    @Override
    public void save(ActivityPrizeManageDTO param) {
        ActivityPrizeEntity updatePrizeEntity = new ActivityPrizeEntity();
        updatePrizeEntity.setId(param.getPrizeId());
        updatePrizeEntity.setExpressCompany(param.getExpressCompany());
        updatePrizeEntity.setExpressNum(param.getExpressNum());
        updatePrizeEntity.setDeliveryAddress(param.getDeliveryAddress());
        updatePrizeEntity.setStatus(ActivityPrizeStatusEnum.GRANT.getCode());
        this.activityPrizeMapper.updateByPrimaryKeySelective(updatePrizeEntity);
    }

    @Override
    public Message savePrizeInfo(ActivityPrizeEntity entity) {
        Long code = this.verificationCodeService.gen(RedisConfig.PRIZE_VERIFICATION_CODE_BUCKET, Long.valueOf(100000L));
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setCode(String.valueOf(code));
        return Message.build((int)this.activityPrizeMapper.insert(entity));
    }

    @Override
    public LotteryCheckResultDTO check(LotteryPrizeCheckParam param) {
        ActivityPrizeEntity prizeEntity = this.activityPrizeMapper.selectByPrimaryKey(param.getPrizeId());
        if (null == prizeEntity) {
            return new LotteryCheckResultDTO(Integer.valueOf(2));
        }
        if (Objects.equals(prizeEntity.getStatus(), ActivityPrizeStatusEnum.CHECKED.getCode())) {
            return new LotteryCheckResultDTO(Integer.valueOf(3));
        }
        ActivityPrizeEntity updatePrizeEntity = new ActivityPrizeEntity();
        updatePrizeEntity.setId(param.getPrizeId());
        updatePrizeEntity.setStatus(ActivityPrizeStatusEnum.CHECKED.getCode());
        updatePrizeEntity.setCheckTime(new Date());
        int result = this.activityPrizeMapper.updateByPrimaryKeySelective(updatePrizeEntity);
        if (result > 0) {
            LotteryPhaseCoreInfoDTO phaseInfo;
            LotteryWinnerEntity winner = this.lotteryWinnerMapper.selectByPrimaryKey(prizeEntity.getBizId());
            if (null != winner && null != (phaseInfo = this.lotteryPhaseMapper.getCorePhaseInfo(winner.getPhaseId())).getMerchantId()) {
                this.lotteryPushService.checkSuccess(phaseInfo.getMerchantId(), phaseInfo.getMerchantUserId(), phaseInfo.getPhaseNum());
            }
            return new LotteryCheckResultDTO(Integer.valueOf(1));
        }
        return new LotteryCheckResultDTO(Integer.valueOf(3));
    }

    @Override
    public ActivityPrizeInfoDTO getPrizeInfo(LotteryPrizeParam param) {
        String prizeCode = param.getCode();
        if (StringUtils.isBlank((CharSequence)prizeCode) || !StringUtils.isNumeric((CharSequence)prizeCode)) {
            return this.invalidResult();
        }
        ActivityPrizeInfoDTO prizeInfo = this.activityPrizeMapper.getPrizeByCode(prizeCode);
        if (prizeInfo == null) {
            return this.invalidResult();
        }
        if (!Objects.equals(prizeInfo.getMerchantId(), param.getMerchantId())) {
            log.warn("\u6838\u9500\u7801\u7684\u6240\u5c5e\u5546\u5bb6\u4e0e\u8bf7\u6c42\u5546\u5bb6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6c42\u5546\u5bb6ID:{}\uff0c\u6838\u9500\u7801\u4e3a\uff1a{}\uff0c\u6838\u9500\u7801\u6240\u5c5e\u5546\u5bb6\u4e3a\uff1a{}", new Object[]{param.getMerchantId(), param.getCode(), prizeInfo.getMerchantId()});
            return this.invalidResult();
        }
        prizeInfo.setWinnerUserVipFlag(this.userIntegrationService.isVip(prizeInfo.getWinnerUserId()));
        return prizeInfo;
    }

    private ActivityPrizeInfoDTO invalidResult() {
        return ActivityPrizeInfoDTO.builder().status(Integer.valueOf(3)).build();
    }
}

