/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.merchant.common.utils.URLUtils;
import com.bxm.localnews.merchant.domain.lottery.LotteryParticipatorMapper;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.integration.MsgPushIntegrationService;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.ImmutableMap;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LotteryPushServiceImpl
implements LotteryPushService {
    private static final Logger log = LoggerFactory.getLogger(LotteryPushServiceImpl.class);
    private final MessageSender messageSender;
    private final DomainIntegrationService domainIntegrationService;
    private final MsgPushIntegrationService msgPushIntegrationService;
    private final LotteryParticipatorMapper lotteryParticipatorMapper;
    private final ActivityProperties activityProperties;
    private final LocationIntegrationService locationIntegrationService;

    @Override
    public void lotteryDraw(Long userId, String lotteryTitle) {
        String title = "\u593a\u5b9d\u5f00\u5956\u901a\u77e5";
        String content = "\u4f60\u53c2\u4e0e\u7684\"" + lotteryTitle + "\"\u5df2\u5f00\u5956\uff0c\u5feb\u770b\u770b\u4e2d\u5956\u7684\u662f\u4e0d\u662f\u4f60\uff01\u53bb\u770b\u770b>>";
        ImmutableMap paramMap = ImmutableMap.of((Object)"userId", (Object)"{userId}", (Object)"areaName", (Object)"{areaName}", (Object)"areaCode", (Object)"{areaCode}");
        String protocolUrl = this.buildH5Url("/tk/raffle.html#/myRaffleList", (Map<String, Object>)paramMap);
        PushMessage message = PushMessage.build((String)title, (String)content).assign(userId).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));
        this.messageSender.sendPushMessage(message);
    }

    @Override
    public void createLottery(Long merchantId, Long merchantUserId, Date startTime) {
        String startTimeStr;
        int tabSelect;
        String title = "\u593a\u5b9d\u6d3b\u52a8\u521b\u5efa\u5b8c\u6210";
        if (null == startTime || DateUtils.before((Date)startTime, (Date)new Date())) {
            tabSelect = 1;
            startTimeStr = "\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb";
        } else {
            startTimeStr = "\u6d3b\u52a8\u5c06\u4e8e" + ((DateFormat)DateUtils.DATE_TIME_FORMAT_THREAD_LOCAL.get()).format(startTime) + "\u5f00\u59cb";
            tabSelect = 2;
        }
        String content = "\u60a8\u7684\u593a\u5b9d\u6d3b\u52a8\u5df2\u521b\u5efa\u5b8c\u6210\uff0c" + startTimeStr + "\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
        ImmutableMap paramMap = ImmutableMap.of((Object)"userId", (Object)"{userId}", (Object)"merchantId", (Object)merchantId, (Object)"tabSelect", (Object)tabSelect, (Object)"areaCode", (Object)"{areaCode}");
        String protocolUrl = this.buildH5Url("/tk/raffle.html#/raffleList", (Map<String, Object>)paramMap);
        PushMessage message = PushMessage.build((String)title, (String)content).assign(merchantUserId).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));
        this.messageSender.sendPushMessage(message);
    }

    @Override
    public void startPhase(Long merchantUserId, Integer phaseNum, Long phaseId, Long lotteryId) {
        String title = "\u60a8\u7684\u593a\u5b9d\u6d3b\u52a8\u5f00\u59cb\u4e86";
        String content = "\u60a8\u7684\u593a\u5b9d\u6d3b\u52a8\u3010\u7b2c" + phaseNum + "\u671f\u3011\u5df2\u7ecf\u5f00\u59cb\u4e86\uff0c\u8d76\u5feb\u53bb\u5206\u4eab\u7ed9\u66f4\u591a\u597d\u53cb\u53c2\u4e0e\u5427";
        ImmutableMap paramMap = ImmutableMap.of((Object)"userId", (Object)"{userId}", (Object)"phaseId", (Object)phaseId, (Object)"lotteryId", (Object)lotteryId, (Object)"areaName", (Object)"{areaName}", (Object)"areaCode", (Object)"{areaCode}");
        String protocolUrl = this.buildH5Url("/tk/raffle.html#/details", (Map<String, Object>)paramMap);
        PushMessage message = PushMessage.build((String)title, (String)content).assign(merchantUserId).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));
        this.messageSender.sendPushMessage(message);
    }

    @Override
    public void finishPhase(Long merchantId, Long merchantUserId, Integer phaseNum) {
        String title = "\u60a8\u7684\u593a\u5b9d\u6d3b\u52a8\u5df2\u7ed3\u675f";
        String content = "\u60a8\u7684\u593a\u5b9d\u6d3b\u52a8\u3010\u7b2c" + phaseNum + "\u671f\u3011\u5df2\u7ed3\u675f\uff0c\u8bf7\u51c6\u5907\u597d\u4e2d\u5956\u987e\u5ba2\u5230\u5e97\u6d88\u8d39\u7684\u51c6\u5907\u54e6";
        this.pushRaffleListMessage(merchantId, merchantUserId, title, content);
    }

    @Override
    public void checkSuccess(Long merchantId, Long merchantUserId, Integer phaseNum) {
        String title = "\u593a\u5b9d\u5546\u54c1\u6838\u9500\u6210\u529f";
        String content = "\u593a\u5b9d\u6d3b\u52a8\u3010\u7b2c" + phaseNum + "\u671f\u3011\u7684\u4e2d\u5956\u7528\u6237\u6838\u9500\u6210\u529f\uff0c\u62a5\u540d\u66f4\u591a\u593a\u5b9d\u6d3b\u52a8\uff0c\u4e3a\u5e97\u94fa\u66dd\u5149\u5f15\u6d41\u54e6~";
        this.pushRaffleListMessage(merchantId, merchantUserId, title, content);
    }

    private void pushRaffleListMessage(Long merchantId, Long merchantUserId, String title, String content) {
        ImmutableMap paramMap = ImmutableMap.of((Object)"userId", (Object)"{userId}", (Object)"merchantId", (Object)merchantId, (Object)"tabSelect", (Object)3, (Object)"areaCode", (Object)"{areaCode}");
        String protocolUrl = this.buildH5Url("/tk/raffle.html#/raffleList", (Map<String, Object>)paramMap);
        PushMessage message = PushMessage.build((String)title, (String)content).assign(merchantUserId).setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE).setProtocol(protocolUrl));
        this.messageSender.sendPushMessage(message);
    }

    private String buildH5Url(String pageUrl, Map<String, Object> paramMap) {
        return URLUtils.buildH5Url((String)this.domainIntegrationService.getInnerH5BaseUrl(), (String)pageUrl, paramMap);
    }

    @Override
    public void lotteryDrawOfficeAccountMsg(MerchantInfo merchantInfo, LotteryJoinContext context, String lotteryTitle, Long userId, String areaName) {
        Long phaseId = context.getParam().getPhaseId();
        List userLotteryCode = this.lotteryParticipatorMapper.getUserLotteryCodeByPhaseId(userId, phaseId, this.activityProperties.getMaxCodeSize());
        ArrayList codeList = new ArrayList();
        userLotteryCode.forEach(lotteryCode -> codeList.add(lotteryCode.getCode()));
        String codes = String.join((CharSequence)",", codeList);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("inviterId", userId);
        paramMap.put("areaCode", context.getParam().getAreaCode());
        paramMap.put("areaName", areaName);
        paramMap.put("lng", merchantInfo.getLng());
        paramMap.put("lat", merchantInfo.getLat());
        paramMap.put("sourcePhaseId", context.getParam().getSourcePhaseId());
        paramMap.put("phaseId", phaseId);
        paramMap.put("lotteryId", context.getPhaseInfo().getLotteryId());
        String protocolUrl = this.raffleFixedUrl(paramMap);
        this.msgPushIntegrationService.doOfficialAccountPush(userId, lotteryTitle, codes, protocolUrl);
    }

    private String raffleFixedUrl(Map<String, Object> paramMap) {
        String h5BaseUrl = this.getH5BaseUrl();
        if (h5BaseUrl == null) {
            return null;
        }
        StringBuilder finalUrl = new StringBuilder(h5BaseUrl);
        finalUrl.append("/tk/raffle.html#/wxdetails");
        if (null != paramMap) {
            finalUrl.append("?");
            paramMap.forEach((key, value) -> finalUrl.append((String)key).append("=").append(value).append("&"));
            finalUrl.deleteCharAt(finalUrl.length() - 1);
        }
        return finalUrl.toString();
    }

    private String getH5BaseUrl() {
        Optional viewSceneBaseUrl;
        try {
            viewSceneBaseUrl = this.domainIntegrationService.getViewSceneBaseUrl(DomainScene.DomainViewScene.WX_JS_VIEW);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return viewSceneBaseUrl.map(ViewSceneDomain::getBaseUrl).orElse(null);
    }

    public LotteryPushServiceImpl(MessageSender messageSender, DomainIntegrationService domainIntegrationService, MsgPushIntegrationService msgPushIntegrationService, LotteryParticipatorMapper lotteryParticipatorMapper, ActivityProperties activityProperties, LocationIntegrationService locationIntegrationService) {
        this.messageSender = messageSender;
        this.domainIntegrationService = domainIntegrationService;
        this.msgPushIntegrationService = msgPushIntegrationService;
        this.lotteryParticipatorMapper = lotteryParticipatorMapper;
        this.activityProperties = activityProperties;
        this.locationIntegrationService = locationIntegrationService;
    }
}

