/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.common.utils.ValidateUtils;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryAreaMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.AreaInfoDTO;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryAwardDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryDetailDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryDetailFacadeDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryMerchantInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryOverviewDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryAreaEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryChangeStatusParam;
import com.bxm.localnews.merchant.param.activity.LotteryManageParam;
import com.bxm.localnews.merchant.param.activity.LotteryRemoveParam;
import com.bxm.localnews.merchant.service.enums.LotteryStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryAwardService;
import com.bxm.localnews.merchant.service.lottery.LotteryMerchantService;
import com.bxm.localnews.merchant.service.lottery.LotteryPhaseService;
import com.bxm.localnews.merchant.service.lottery.LotteryPushService;
import com.bxm.localnews.merchant.service.lottery.LotteryService;
import com.bxm.localnews.merchant.service.task.LotteryAutoEnableCallback;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTask;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LotteryServiceImpl
implements LotteryService {
    private static final Logger log = LoggerFactory.getLogger(LotteryServiceImpl.class);
    private final LotteryMapper lotteryMapper;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final LotteryAreaMapper lotteryAreaMapper;
    private final ActivityAwardMapper activityAwardMapper;
    private final LocationIntegrationService locationIntegrationService;
    private LotteryPhaseService lotteryPhaseService;
    private final SequenceCreater sequenceCreater;
    private final ScheduleService scheduleService;
    private final LotteryAutoEnableCallback lotteryAutoEnableCallback;
    private final LotteryPushService lotteryPushService;
    private final LotteryAwardService lotteryAwardService;
    private final LotteryMerchantService lotteryMerchantService;

    @Autowired
    public LotteryServiceImpl(LotteryMapper lotteryMapper, LotteryAreaMapper lotteryAreaMapper, LocationIntegrationService locationIntegrationService, SequenceCreater sequenceCreater, ScheduleService scheduleService, LotteryAutoEnableCallback lotteryAutoEnableCallback, LotteryPushService lotteryPushService, LotteryAwardService lotteryAwardService, LotteryMerchantService lotteryMerchantService, LotteryPhaseMapper lotteryPhaseMapper, ActivityAwardMapper activityAwardMapper) {
        this.lotteryMapper = lotteryMapper;
        this.lotteryAreaMapper = lotteryAreaMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.sequenceCreater = sequenceCreater;
        this.scheduleService = scheduleService;
        this.lotteryAutoEnableCallback = lotteryAutoEnableCallback;
        this.lotteryPushService = lotteryPushService;
        this.lotteryAwardService = lotteryAwardService;
        this.lotteryMerchantService = lotteryMerchantService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.activityAwardMapper = activityAwardMapper;
    }

    private LotteryPhaseService getLotteryPhaseService() {
        if (this.lotteryPhaseService == null) {
            this.lotteryPhaseService = (LotteryPhaseService)SpringContextHolder.getBean(LotteryPhaseService.class);
        }
        return this.lotteryPhaseService;
    }

    @Override
    public Message changeStatus(LotteryChangeStatusParam param, LotteryStatusEnum status) {
        if (null != status) {
            log.info("\u6d3b\u52a8[{}]\u72b6\u6001\u53d8\u66f4\uff0c\u4e0a\u4e0b\u67b6\uff1a{},\u72b6\u6001\u53d8\u66f4\uff1a{}", new Object[]{param.getLotteryId(), param.getEnable(), status.name()});
        } else {
            log.info("\u6d3b\u52a8[{}]\u72b6\u6001\u53d8\u66f4\uff0c\u4e0a\u4e0b\u67b6\uff1a{}", (Object)param.getLotteryId(), (Object)param.getEnable());
        }
        LotteryEntity updateEntity = new LotteryEntity();
        updateEntity.setId(param.getLotteryId());
        updateEntity.setModifyTime(new Date());
        LotteryEntity entity = this.lotteryMapper.selectByPrimaryKey(param.getLotteryId());
        if (param.getEnable().booleanValue()) {
            updateEntity.setEnable(Integer.valueOf(1));
            if (DateUtils.before((Date)entity.getStartTime(), (Date)new Date())) {
                updateEntity.setStatus(LotteryStatusEnum.ACTIVED.getCode());
            } else {
                updateEntity.setStatus(LotteryStatusEnum.UNDER_PLANNING.getCode());
            }
        } else {
            if (null != status) {
                updateEntity.setStatus(status.getCode());
            }
            updateEntity.setEnable(Integer.valueOf(0));
        }
        Message message = Message.build((int)this.lotteryMapper.updateByPrimaryKeySelective(updateEntity));
        if (message.isSuccess()) {
            if (param.getEnable().booleanValue()) {
                if (entity.getCurrentPhaseId() != null) {
                    this.getLotteryPhaseService().resume(entity.getId(), entity.getCurrentPhaseId());
                } else if (DateUtils.before((Date)entity.getStartTime(), (Date)new Date())) {
                    this.getLotteryPhaseService().create(entity.getId());
                }
            } else {
                this.getLotteryPhaseService().cancel(entity.getId(), entity.getCurrentPhaseId(), false);
            }
        }
        return message;
    }

    @Override
    public Message remove(LotteryRemoveParam param) {
        LotteryEntity lotteryEntity = this.lotteryMapper.selectByPrimaryKey(param.getLotteryId());
        if (Objects.equals(LotteryStatusEnum.ACTIVED.getCode(), lotteryEntity.getStatus())) {
            return Message.build((boolean)false, (String)"\u4e0a\u67b6\u4e2d\u7684\u6d3b\u52a8\u4e0d\u652f\u6301\u5220\u9664\u64cd\u4f5c");
        }
        LotteryEntity entity = new LotteryEntity();
        entity.setId(param.getLotteryId());
        entity.setDeleteUserId(param.getCurrentUserId());
        entity.setDeleteFlag(Integer.valueOf(1));
        entity.setDeleteTime(new Date());
        return Message.build((int)this.lotteryMapper.remove(entity));
    }

    @Override
    public LotteryDetailDTO get(Long lotteryId) {
        LotteryEntity entity = this.lotteryMapper.selectByPrimaryKey(lotteryId);
        LotteryAwardEntityWithBLOBs awardInfo = this.activityAwardMapper.selectByPrimaryKey(entity.getAwardId());
        LotteryDetailDTO detailDTO = new LotteryDetailDTO();
        BeanUtils.copyProperties((Object)entity, (Object)detailDTO);
        detailDTO.setLotteryId(entity.getId());
        int useStock = awardInfo.getUseStock() == null ? 0 : awardInfo.getUseStock();
        int totalStock = awardInfo.getStock() == null ? 0 : awardInfo.getStock();
        int resultStock = totalStock - useStock;
        detailDTO.setStock(Integer.valueOf(Math.max(resultStock, 0)));
        detailDTO.setAwardTitle(awardInfo.getTitle());
        if (Objects.equals(0, entity.getGlobalFlag())) {
            detailDTO.setAreaInfos(this.loadAreaInfo(lotteryId));
        }
        return detailDTO;
    }

    @Override
    public Message setLastPhase(Long lotteryId, Long lastPhaseId, Integer lastPhaseNum) {
        LotteryEntity updateEntity = new LotteryEntity();
        updateEntity.setId(lotteryId);
        updateEntity.setCurrentPhaseId(lastPhaseId);
        updateEntity.setCurrentPhaseNum(lastPhaseNum);
        if (null == lastPhaseId) {
            return Message.build((int)this.lotteryMapper.removeLastPhase(lotteryId));
        }
        return Message.build((int)this.lotteryMapper.updateByPrimaryKeySelective(updateEntity));
    }

    private List<AreaInfoDTO> loadAreaInfo(Long lotteryId) {
        List areaCodes = this.lotteryAreaMapper.queryByLotteryId(lotteryId);
        return areaCodes.stream().map(areaCode -> {
            LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(areaCode);
            AreaInfoDTO areaInfo = new AreaInfoDTO();
            areaInfo.setAreaCode(areaCode);
            areaInfo.setAreaName(locationByGeocode.getName());
            return areaInfo;
        }).collect(Collectors.toList());
    }

    @Override
    public Message saveOrUpdate(LotteryDetailDTO param) {
        int result;
        LotteryEntity entity = new LotteryEntity();
        BeanUtils.copyProperties((Object)param, (Object)entity);
        entity.setId(param.getLotteryId());
        entity.setEnable(Integer.valueOf(0));
        entity.setStatus(LotteryStatusEnum.UNDER_PLANNING.getCode());
        String errorMsg = ValidateUtils.fastValid((Object)entity);
        if (null != errorMsg) {
            return Message.build((boolean)false, (String)errorMsg);
        }
        Message message = this.check(entity);
        if (!message.isSuccess()) {
            return message;
        }
        if (null == param.getLotteryId()) {
            entity.setId(this.sequenceCreater.nextLongId());
            entity.setCreateTime(new Date());
            entity.setCreator(param.getCurrentUserId());
            entity.setDeleteFlag(Integer.valueOf(0));
            entity.setCurrentPhaseNum(Integer.valueOf(0));
            result = this.lotteryMapper.insert(entity);
            this.afterCreate(entity);
        } else {
            LotteryEntity existsLottery = this.lotteryMapper.selectByPrimaryKey(param.getLotteryId());
            if (null != existsLottery.getCurrentPhaseId()) {
                this.getLotteryPhaseService().cancel(entity.getId(), existsLottery.getCurrentPhaseId(), false);
            }
            entity.setModifyTime(new Date());
            result = this.lotteryMapper.updateByPrimaryKeySelective(entity);
        }
        this.createTask(entity);
        this.lotteryAreaMapper.removeByLotteryId(entity.getId());
        if (Objects.equals(entity.getGlobalFlag(), 0)) {
            this.saveAreaInfo(entity.getId(), param);
        }
        return Message.build((int)result);
    }

    private Message check(LotteryEntity entity) {
        if (Objects.equals(entity.getActualFlag(), 0) && Objects.equals(entity.getVirtualFlag(), 0)) {
            return Message.build((boolean)false, (String)"\u9a6c\u7532\u53f7\u4e2d\u5956\u7684\u6d3b\u52a8\u5fc5\u987b\u5141\u8bb8\u9a6c\u7532\u53f7\u53c2\u4e0e");
        }
        return Message.build();
    }

    private void afterCreate(LotteryEntity entity) {
        LotteryMerchantInfoDTO merchantInfo;
        LotteryAwardDetailDTO awardDetailDTO = this.lotteryAwardService.get(entity.getAwardId());
        if (null != awardDetailDTO.getMerchantId() && Objects.nonNull(merchantInfo = this.lotteryMerchantService.get(awardDetailDTO.getMerchantId())) && Objects.nonNull(merchantInfo.getMerchantUserId())) {
            this.lotteryPushService.createLottery(awardDetailDTO.getMerchantId(), merchantInfo.getMerchantUserId(), entity.getStartTime());
        }
    }

    private void saveAreaInfo(Long lotteryId, LotteryDetailDTO param) {
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCodeStr())) {
            String[] areaCodeList;
            for (String areaCode : areaCodeList = param.getAreaCodeStr().split(",")) {
                LotteryAreaEntity entity = new LotteryAreaEntity();
                entity.setId(this.sequenceCreater.nextLongId());
                entity.setLotteryId(lotteryId);
                entity.setAreaCode(areaCode.trim());
                this.lotteryAreaMapper.insert(entity);
            }
        }
    }

    private void createTask(LotteryEntity entity) {
        String taskName = ((Object)((Object)this.lotteryAutoEnableCallback)).getClass().getSimpleName() + "_" + entity.getId();
        this.scheduleService.remove(taskName);
        if (null == entity.getStartTime() || DateUtils.before((Date)entity.getStartTime(), (Date)new Date())) {
            return;
        }
        OnceTask expiredTask = OnceTaskBuilder.builder((String)taskName, (Date)entity.getStartTime(), (TaskCallback)this.lotteryAutoEnableCallback).callbackParam((Object)entity.getId()).description("\u5b9a\u65f6\u5f00\u542f\u593a\u5b9d\u6d3b\u52a8\uff1a" + entity.getId()).build();
        this.scheduleService.push((ScheduleTask)expiredTask);
    }

    @Override
    public PageWarper<LotteryOverviewDTO> query(LotteryManageParam param) {
        List result = this.lotteryMapper.queryByPage(param);
        for (LotteryOverviewDTO lotteryOverviewDTO : result) {
            if (lotteryOverviewDTO.getGlobalFlag().booleanValue()) continue;
            lotteryOverviewDTO.setAreaList(this.loadAreaInfo(lotteryOverviewDTO.getLotteryId()));
        }
        return new PageWarper(result);
    }

    @Override
    public LotteryDetailFacadeDTO queryLastEnableLotteryInfo(String areaCode) {
        return this.lotteryPhaseMapper.queryLastEnableLotteryInfo(areaCode);
    }
}

