/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.bxm.localnews.merchant.domain.lottery.LotteryCounterMapper;
import com.bxm.localnews.merchant.entity.lottery.LotteryCounterEntity;
import com.bxm.localnews.merchant.service.lottery.LotteryStatisticsService;
import com.bxm.localnews.merchant.service.lottery.event.LotteryEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryFollowEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryJoinEvent;
import com.bxm.localnews.merchant.service.lottery.event.LotteryShowEvent;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LotteryStatisticsServiceImpl
implements LotteryStatisticsService,
ApplicationContextAware {
    private final LotteryCounterMapper lotteryCounterMapper;
    private final SequenceCreater sequenceCreater;
    private ApplicationContext applicationContext;

    @Autowired
    public LotteryStatisticsServiceImpl(LotteryCounterMapper lotteryCounterMapper, SequenceCreater sequenceCreater) {
        this.lotteryCounterMapper = lotteryCounterMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public void post(LotteryEvent event) {
        this.applicationContext.publishEvent((Object)event);
    }

    @Override
    @EventListener
    @Async
    public void addLotteryShow(LotteryShowEvent event) {
        LotteryCounterEntity entity = new LotteryCounterEntity();
        entity.setLotteryId(event.getLotteryId());
        entity.setPhaseId(event.getPhaseId());
        entity.setShowNum(Integer.valueOf(1));
        this.lotteryCounterMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    @EventListener
    @Async
    public void addLotteryJoin(LotteryJoinEvent event) {
        LotteryCounterEntity entity = new LotteryCounterEntity();
        entity.setLotteryId(event.getLotteryId());
        entity.setPhaseId(event.getPhaseId());
        entity.setJoinNum(Integer.valueOf(1));
        this.lotteryCounterMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    @EventListener
    @Async
    public void addLotteryFollow(LotteryFollowEvent event) {
        LotteryCounterEntity entity = new LotteryCounterEntity();
        entity.setLotteryId(event.getLotteryId());
        entity.setPhaseId(event.getPhaseId());
        entity.setFunsNum(Integer.valueOf(1));
        this.lotteryCounterMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public void setup(Long lotteryId, Long phaseId) {
        LotteryCounterEntity entity = new LotteryCounterEntity();
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setLotteryId(lotteryId);
        entity.setPhaseId(phaseId);
        entity.setFunsNum(Integer.valueOf(0));
        entity.setShowNum(Integer.valueOf(0));
        entity.setJoinNum(Integer.valueOf(0));
        entity.setCreateTime(new Date());
        this.lotteryCounterMapper.insert(entity);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

