/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityAwardMapper;
import com.bxm.localnews.merchant.domain.lottery.ActivityPrizeMapper;
import com.bxm.localnews.merchant.domain.lottery.LotteryWinnerMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPosterInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerAwardDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryWinnerDialogDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityPrizeEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryAwardEntityWithBLOBs;
import com.bxm.localnews.merchant.entity.lottery.LotteryWinnerEntity;
import com.bxm.localnews.merchant.integration.ForumPostIntegrationService;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryAwardAndPostParam;
import com.bxm.localnews.merchant.param.activity.LotteryBaseParam;
import com.bxm.localnews.merchant.param.activity.LotteryWinnerParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.AwardTypeEnum;
import com.bxm.localnews.merchant.service.enums.LotteryWinnerStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryWinnerService;
import com.bxm.localnews.merchant.vo.ForumBasicVo;
import com.bxm.localnews.merchant.vo.PostImgVo;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LotteryWinnerServiceImpl
implements LotteryWinnerService {
    private static final Logger log = LoggerFactory.getLogger(LotteryWinnerServiceImpl.class);
    private final LotteryWinnerMapper lotteryWinnerMapper;
    private final ActivityAwardMapper activityAwardMapper;
    private final SequenceCreater sequenceCreater;
    private final MerchantInfoMapper merchantInfoMapper;
    private final ActivityPrizeMapper activityPrizeMapper;
    private final ForumPostIntegrationService forumPostIntegrationService;
    private final LocationIntegrationService locationIntegrationService;
    private final ActivityProperties activityProperties;

    @Override
    public Message saveWinner(LotteryWinnerEntity entity) {
        entity.setId(this.sequenceCreater.nextLongId());
        return Message.build((int)this.lotteryWinnerMapper.insert(entity));
    }

    @Override
    public LotteryWinnerDialogDTO getUserWinnerDialogInfo(LotteryBaseParam param) {
        return this.lotteryWinnerMapper.getUserUnReceiveInfo(param);
    }

    @Override
    public LotteryPosterInfoDTO getWinnerPosterInfo(LotteryWinnerParam param) {
        return this.lotteryWinnerMapper.getWinnerPosterInfo(param);
    }

    @Override
    public LotteryWinnerAwardDTO getWinnerAwardInfo(LotteryWinnerParam param) {
        LotteryWinnerEntity lotteryWinnerEntity = this.lotteryWinnerMapper.selectByPrimaryKey(param.getWinnerRecordId());
        Long awardId = lotteryWinnerEntity.getAwardId();
        LotteryAwardEntityWithBLOBs awardInfo = this.activityAwardMapper.selectByPrimaryKey(awardId);
        if (awardInfo == null) {
            return new LotteryWinnerAwardDTO();
        }
        LotteryWinnerAwardDTO resultDTO = new LotteryWinnerAwardDTO();
        resultDTO.setAwardTitle(awardInfo.getTitle());
        resultDTO.setAwardType(awardInfo.getType());
        if (awardInfo.getType().equals(AwardTypeEnum.GOODS.getCode())) {
            Long merchantId = awardInfo.getMerchantId();
            MerchantInfo merchantInfo = this.merchantInfoMapper.selectByPrimaryKey(merchantId);
            resultDTO.setMerchantAddress(merchantInfo.getAddress());
            resultDTO.setMerchantPhone(merchantInfo.getMobile());
            ActivityPrizeEntity winnerPrizeInfo = this.activityPrizeMapper.getPrizeInfoByWinnerId(param.getWinnerRecordId());
            resultDTO.setCode(winnerPrizeInfo.getCode());
        }
        return resultDTO;
    }

    @Override
    public void awardAndPost(LotteryAwardAndPostParam param) {
        if (param.getWinnerRecordId() == null) {
            log.warn("\u9886\u5956\u65f6\u4f20\u5165\u7684\u4e2d\u5956\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a\uff1a{}", (Object)param);
            return;
        }
        LotteryWinnerEntity lotteryWinnerEntity = this.lotteryWinnerMapper.selectByPrimaryKey(param.getWinnerRecordId());
        if (lotteryWinnerEntity == null) {
            log.warn("\u4e2d\u5956\u8bb0\u5f55\u4e0d\u5b58\u5728\uff1a{}", (Object)param);
            return;
        }
        if (!LotteryWinnerStatusEnum.UN_RECEIVE.getCode().equals(lotteryWinnerEntity.getStatus())) {
            log.warn("\u4e2d\u5956\u8bb0\u5f55\u5fc5\u987b\u4e3a\u672a\u9886\u53d6\uff1a{}", (Object)param);
            return;
        }
        LotteryWinnerEntity updateWinnerEntity = new LotteryWinnerEntity();
        updateWinnerEntity.setId(param.getWinnerRecordId());
        updateWinnerEntity.setStatus(LotteryWinnerStatusEnum.RECEIVE.getCode());
        this.lotteryWinnerMapper.updateByPrimaryKeySelective(updateWinnerEntity);
        this.createFlauntPost(param, lotteryWinnerEntity);
    }

    private void createFlauntPost(LotteryAwardAndPostParam param, LotteryWinnerEntity lotteryWinnerEntity) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u70ab\u8000\u5e16\u5b50, param: {} lottery: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)lotteryWinnerEntity));
        }
        if (CollectionUtils.isEmpty(this.activityProperties.getFlauntTexts()) || CollectionUtils.isEmpty(this.activityProperties.getExtraContents())) {
            log.warn("\u70ab\u8000\u5e16\u5b50\u6587\u6848\u914d\u7f6e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u70ab\u8000\u5e16\u5b50, param: {} lottery: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)lotteryWinnerEntity));
            return;
        }
        try {
            String flauntText = this.activityProperties.getFlauntTexts().get(RandomUtils.nextInt((int)0, (int)this.activityProperties.getFlauntTexts().size()));
            String extText = this.activityProperties.getExtraContents().get(RandomUtils.nextInt((int)0, (int)this.activityProperties.getExtraContents().size()));
            LotteryAwardEntityWithBLOBs lotteryAward = this.activityAwardMapper.selectByPrimaryKey(lotteryWinnerEntity.getAwardId());
            if (Objects.isNull(lotteryAward)) {
                log.warn("\u5956\u54c1: {} \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u53d1\u9001\u70ab\u8000\u5e16\u5b50", (Object)lotteryWinnerEntity.getAwardId());
                return;
            }
            flauntText = String.format(flauntText, lotteryAward.getTitle());
            extText = String.format(this.activityProperties.getExtraContentElement(), lotteryWinnerEntity.getPhaseId(), extText);
            ForumBasicVo forumBasicVo = new ForumBasicVo();
            forumBasicVo.setUserId(lotteryWinnerEntity.getUserId());
            forumBasicVo.setAreaCode(param.getAreaCode());
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(param.getAreaCode());
            if (Objects.nonNull(locationDTO)) {
                forumBasicVo.setLocation(locationDTO.getName());
            }
            forumBasicVo.setTextField(flauntText);
            forumBasicVo.setExtraContent(extText);
            forumBasicVo.setTopicIdList(Collections.singletonList(this.activityProperties.getFlauntTopicId()));
            forumBasicVo.setIsNewReport(Byte.valueOf((byte)0));
            forumBasicVo.setPostImgList(Collections.singletonList(PostImgVo.buildImg((String)param.getPosterUrl())));
            this.forumPostIntegrationService.createPost(forumBasicVo);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u70ab\u8000\u5e16\u5b50\u51fa\u73b0\u9519\u8bef, param: {} lottery: {}", new Object[]{JSON.toJSONString((Object)param), JSON.toJSONString((Object)lotteryWinnerEntity), e});
        }
    }

    public LotteryWinnerServiceImpl(LotteryWinnerMapper lotteryWinnerMapper, ActivityAwardMapper activityAwardMapper, SequenceCreater sequenceCreater, MerchantInfoMapper merchantInfoMapper, ActivityPrizeMapper activityPrizeMapper, ForumPostIntegrationService forumPostIntegrationService, LocationIntegrationService locationIntegrationService, ActivityProperties activityProperties) {
        this.lotteryWinnerMapper = lotteryWinnerMapper;
        this.activityAwardMapper = activityAwardMapper;
        this.sequenceCreater = sequenceCreater;
        this.merchantInfoMapper = merchantInfoMapper;
        this.activityPrizeMapper = activityPrizeMapper;
        this.forumPostIntegrationService = forumPostIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
        this.activityProperties = activityProperties;
    }
}

