/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.strategy;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.enums.LotteryJoinResultEnum;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.strategy.IJoinStrategy;
import com.bxm.newidea.component.redis.DistributedLock;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JoinStrategyManage {
    private static final Logger log = LoggerFactory.getLogger(JoinStrategyManage.class);
    private final List<IJoinStrategy> strategies;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final DistributedLock distributedLock;

    @Autowired
    public JoinStrategyManage(List<IJoinStrategy> strategies, LotteryPhaseMapper lotteryPhaseMapper, DistributedLock distributedLock) {
        this.strategies = strategies;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.distributedLock = distributedLock;
    }

    @Transactional(rollbackFor={Exception.class})
    public LotteryJoinResultDTO execute(LotteryJoinContext context) {
        String requestId;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\uff0c\u53c2\u4e0e\u53c2\u6570\uff1a[{}]", (Object)context);
        }
        LotteryPhaseJoinParam param = context.getParam();
        String resourceId = RedisConfig.ACTIVITY_LOTTERY_RESOUCE_KEY.copy().appendKey((Object)param.getPhaseId()).appendKey((Object)param.getUserId()).gen();
        if (this.distributedLock.lock(resourceId, requestId = UUID.randomUUID().toString())) {
            context.setPhaseInfo(this.lotteryPhaseMapper.getCorePhaseInfo(param.getPhaseId()));
            for (IJoinStrategy strategy : this.strategies) {
                if (!strategy.match(context)) continue;
                LotteryJoinResultDTO resultDTO = strategy.execute(context);
                log.info("\u53c2\u4e0e\u593a\u5b9d\u6d3b\u52a8\u5b8c\u6210\uff0c\u53c2\u4e0e\u65b9\u5f0f\uff1a{},\u53c2\u4e0e\u53c2\u6570\uff1a{},\u53c2\u4e0e\u7ed3\u679c\uff1a{}", new Object[]{strategy.getClass().getSimpleName(), JSON.toJSONString((Object)param), JSON.toJSONString((Object)resultDTO)});
                this.distributedLock.unlock(resourceId, requestId);
                return resultDTO;
            }
        }
        log.error("\u53c2\u4e0e\u6d3b\u52a8\u5931\u8d25\uff0c\u8bf7\u6c42\u7684\u53c2\u4e0e\u65b9\u5f0f\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u91cd\u590d\u70b9\u51fb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        return LotteryJoinResultDTO.builder().success(Boolean.valueOf(false)).joinResult(LotteryJoinResultEnum.FINISH.getCode()).build();
    }
}

