/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.domain.lottery.LotteryPhaseMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinStateDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryMerchantInfoDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.integration.BizLogIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryCheckJoinTimesParam;
import com.bxm.localnews.merchant.param.activity.LotteryMerchantFollowParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.LotteryJoinResultEnum;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryPhaseStatusEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryDrawService;
import com.bxm.localnews.merchant.service.lottery.LotteryMerchantService;
import com.bxm.localnews.merchant.service.lottery.LotteryParticipatorService;
import com.bxm.localnews.merchant.service.lottery.LotteryStatisticsService;
import com.bxm.localnews.merchant.service.lottery.cache.LotteryCacheManage;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.event.LotteryJoinEvent;
import com.bxm.localnews.merchant.service.lottery.strategy.IJoinStrategy;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJoinStrategy
implements IJoinStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractJoinStrategy.class);
    private LotteryParticipatorService lotteryParticipatorService;
    private LotteryDrawService lotteryDrawService;
    @Resource
    private LotteryPhaseMapper lotteryPhaseMapper;
    @Resource
    protected LotteryCacheManage lotteryCacheManage;
    @Resource
    protected ActivityProperties activityProperties;
    @Resource
    protected UserIntegrationService userIntegrationService;
    @Resource
    private LotteryMerchantService lotteryMerchantService;
    @Resource
    protected LotteryStatisticsService lotteryStatisticsService;
    @Resource
    protected BizLogIntegrationService bizLogIntegrationService;

    LotteryParticipatorService getLotteryParticipatorService() {
        if (null == this.lotteryParticipatorService) {
            this.lotteryParticipatorService = (LotteryParticipatorService)SpringContextHolder.getBean(LotteryParticipatorService.class);
        }
        return this.lotteryParticipatorService;
    }

    private LotteryDrawService getLotteryDrawService() {
        if (this.lotteryDrawService == null) {
            this.lotteryDrawService = (LotteryDrawService)SpringContextHolder.getBean(LotteryDrawService.class);
        }
        return this.lotteryDrawService;
    }

    @Override
    public LotteryJoinResultDTO execute(LotteryJoinContext context) {
        LotteryJoinResultDTO check = this.check(context);
        try {
            if (check.getSuccess().booleanValue()) {
                this.saveParticipator(context);
                check = this.afterExecute(context);
            }
            if (check.getSuccess().booleanValue()) {
                check.setCode(context.getJoinCode());
                if (check.getJoinResult() == null) {
                    check.setJoinResult(LotteryJoinResultEnum.SUCCESS.getCode());
                }
            } else {
                log.info("\u6d3b\u52a8\u53c2\u4e0e\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u53c2\u4e0e\u593a\u5b9d\u6d3b\u52a8\u5931\u8d25,\u53c2\u4e0e\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
            log.error(e.getMessage(), (Throwable)e);
            this.rollback(context);
            throw e;
        }
        return check;
    }

    LotteryJoinResultDTO preCheck(LotteryJoinContext context) {
        return LotteryJoinResultDTO.buildDefault();
    }

    private void rollback(LotteryJoinContext context) {
        this.lotteryCacheManage.decrementJoinNum(context.getPhaseInfo().getPhaseId());
    }

    LotteryJoinResultDTO afterExecute(LotteryJoinContext context) {
        this.triggerDraw(context);
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        if (this.activityProperties.getEnableAutoFollow().booleanValue() && null != phaseInfo.getMerchantUserId() && !Boolean.TRUE.equals(context.getFollowMerchantUser())) {
            this.follow(context, phaseInfo);
        }
        if (null != phaseInfo.getMerchantUserId() && null != phaseInfo.getMerchantId() && LotteryJoinSourceEnum.VIRTUAL.equals((Object)context.getJoinSource())) {
            this.follow(context, phaseInfo);
        }
        this.userIntegrationService.updateUserJudgeMarker(context.getParam().getUserId(), LocalNewsUserJudgeMarkerEnum.JOINED_LOTTERY, true);
        this.lotteryStatisticsService.post(new LotteryJoinEvent(phaseInfo.getLotteryId(), phaseInfo.getPhaseId()));
        return LotteryJoinResultDTO.buildDefault();
    }

    private void follow(LotteryJoinContext context, LotteryPhaseCoreInfoDTO phaseInfo) {
        if (!this.userIntegrationService.isFollow(context.getParam().getUserId(), phaseInfo.getMerchantUserId()).booleanValue()) {
            this.lotteryMerchantService.execAsyncFollow(LotteryMerchantFollowParam.builder().merchantUserId(phaseInfo.getMerchantUserId()).userId(context.getParam().getUserId()).phaseId(phaseInfo.getPhaseId()).build());
        }
    }

    private void triggerDraw(LotteryJoinContext context) {
        if (Boolean.TRUE.equals(context.getSkipTriggerDraw())) {
            return;
        }
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        if ((long)phaseInfo.getTargetNum().intValue() <= context.getCurrentJoinNum() + 1L) {
            log.info("\u89e6\u53d1\u6d3b\u52a8[{}]\u5f00\u5956\uff0c\u76ee\u6807\u4eba\u6570\uff1a{},\u6570\u636e\u5e93\u4e2d\u5f53\u524d\u4eba\u6570\uff1a{},\u7f13\u5b58\u4e2d\u5f53\u524d\u4eba\u6570\uff1a{}", new Object[]{phaseInfo.getPhaseId(), phaseInfo.getTargetNum(), phaseInfo.getCurrentNum(), context.getCurrentJoinNum()});
            this.getLotteryDrawService().execAsyncDraw(context);
        }
    }

    private void fillUserInfo(LotteryJoinContext context) {
        UserInfoDTO cacheUser = context.getUserInfo();
        if (cacheUser == null) {
            cacheUser = this.userIntegrationService.getUserFromRedisDB(context.getParam().getUserId());
            context.setUserInfo(cacheUser);
        }
    }

    void setJoinTimesInfo(LotteryJoinContext context) {
        this.fillUserInfo(context);
        LotteryCheckJoinTimesParam param = LotteryCheckJoinTimesParam.builder().maxTimes(context.getPhaseInfo().getMaxTimes()).maxType(context.getPhaseInfo().getMaxType()).phaseId(context.getPhaseInfo().getPhaseId()).platform(Integer.valueOf(context.getParam().getPlatform())).userCreateTime(context.getUserInfo().getCreateTime()).userId(context.getParam().getUserId()).build();
        LotteryJoinStateDTO joinInfo = this.getLotteryParticipatorService().getJoinInfo(param);
        context.setJoinTimesInfo(joinInfo);
    }

    private void saveParticipator(LotteryJoinContext context) {
        Long userId = context.getParam().getUserId();
        this.fillUserInfo(context);
        UserInfoDTO cacheUser = context.getUserInfo();
        Long currentJoinNum = this.lotteryCacheManage.incrementJoinNum(context.getPhaseInfo().getPhaseId());
        context.setCurrentJoinNum(currentJoinNum);
        LotteryParticipatorEntity entity = new LotteryParticipatorEntity();
        entity.setPhaseId(context.getPhaseInfo().getPhaseId());
        entity.setLotteryId(context.getPhaseInfo().getLotteryId());
        entity.setUserId(userId);
        entity.setNickName(cacheUser.getNickname());
        entity.setHeadImg(cacheUser.getHeadImg());
        entity.setCode(String.valueOf(this.activityProperties.getJoinCodeStartIndex() + currentJoinNum));
        if (context.getJoinTime() == null) {
            entity.setCreateTime(new Date());
        } else {
            entity.setCreateTime(context.getJoinTime());
        }
        this.fillParticipator(entity);
        this.getLotteryParticipatorService().save(entity);
        if (!Objects.equals(LotteryJoinSourceEnum.VIRTUAL.getCode(), entity.getSource())) {
            this.lotteryCacheManage.addJoinCode(entity.getPhaseId(), entity.getUserId(), entity.getCode(), entity.getSource());
        }
        this.lotteryPhaseMapper.addJoinNum(context.getPhaseInfo().getPhaseId());
        context.setJoinCode(entity.getCode());
    }

    abstract void fillParticipator(LotteryParticipatorEntity var1);

    private LotteryJoinResultDTO check(LotteryJoinContext context) {
        boolean complete;
        boolean unexpectStatus;
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        if (Boolean.TRUE.equals(context.getSkipTriggerDraw())) {
            return LotteryJoinResultDTO.buildDefault();
        }
        boolean bl = unexpectStatus = !Objects.equals(phaseInfo.getStatus(), LotteryPhaseStatusEnum.GOING.getCode());
        if (unexpectStatus) {
            LotteryJoinResultDTO resultDTO = this.buildFinishResult(phaseInfo);
            resultDTO.setLastPhaseId(phaseInfo.getLastPhaseId());
            return resultDTO;
        }
        Long joinNum = this.lotteryCacheManage.getJoinNum(phaseInfo.getPhaseId());
        boolean bl2 = complete = joinNum + 2L > (long)phaseInfo.getTargetNum().intValue();
        if (complete) {
            log.info("\u53c2\u4e0e\u4eba\u6570\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u53c2\u4e0e");
            return this.buildFinishResult(phaseInfo);
        }
        LotteryJoinResultDTO resultDTO = this.preCheck(context);
        if (null == resultDTO) {
            resultDTO = LotteryJoinResultDTO.buildDefault();
        }
        return resultDTO;
    }

    private LotteryJoinResultDTO buildFinishResult(LotteryPhaseCoreInfoDTO phaseInfo) {
        LotteryJoinResultDTO resultDTO = LotteryJoinResultDTO.builder().joinResult(LotteryJoinResultEnum.FINISH.getCode()).success(Boolean.valueOf(false)).build();
        if (null != phaseInfo.getLastPhaseId()) {
            resultDTO.setLastPhaseId(phaseInfo.getLastPhaseId());
        }
        return resultDTO;
    }

    LotteryJoinResultDTO checkFollow(LotteryJoinContext context) {
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        Long merchantUserId = phaseInfo.getMerchantUserId();
        if (this.activityProperties.getEnableAutoFollow().booleanValue() || null == merchantUserId) {
            return LotteryJoinResultDTO.buildDefault();
        }
        if (merchantUserId.equals(context.getParam().getUserId())) {
            return LotteryJoinResultDTO.buildDefault();
        }
        boolean follow = this.userIntegrationService.isFollow(context.getParam().getUserId(), merchantUserId);
        context.setFollowMerchantUser(follow);
        if (!follow) {
            LotteryMerchantInfoDTO merchantInfoDTO = this.lotteryMerchantService.get(phaseInfo.getMerchantId());
            return LotteryJoinResultDTO.builder().joinResult(LotteryJoinResultEnum.UNFOLLOW.getCode()).hasAward(Boolean.valueOf(phaseInfo.getWelfareType() > 0)).merchantInfoDTO(merchantInfoDTO).success(Boolean.valueOf(true)).build();
        }
        return LotteryJoinResultDTO.buildDefault();
    }
}

