/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.strategy.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.integration.UserAccountIntegrationService;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.enums.LotteryJoinResultEnum;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.strategy.impl.AbstractJoinStrategy;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppJoinStrategy
extends AbstractJoinStrategy {
    private static final Logger log = LoggerFactory.getLogger(AppJoinStrategy.class);
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Override
    LotteryJoinResultDTO preCheck(LotteryJoinContext context) {
        this.setJoinTimesInfo(context);
        LotteryJoinResultDTO resultDTO = this.checkTimes(context);
        if (resultDTO.getSuccess().booleanValue()) {
            resultDTO = this.deductGold(context);
        }
        return resultDTO;
    }

    private LotteryJoinResultDTO checkTimes(LotteryJoinContext context) {
        if (context.getJoinTimesInfo().getJoinTimes() <= 0) {
            return LotteryJoinResultDTO.builder().joinResult(LotteryJoinResultEnum.MAX_TIMES.getCode()).success(Boolean.valueOf(false)).build();
        }
        return LotteryJoinResultDTO.buildDefault();
    }

    private LotteryJoinResultDTO deductGold(LotteryJoinContext context) {
        LotteryPhaseJoinParam param;
        boolean result;
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        if (phaseInfo.getExpendGold() <= 0) {
            return LotteryJoinResultDTO.buildDefault();
        }
        if (context.getJoinTimesInfo().getNewbie().booleanValue()) {
            Long userId = context.getParam().getUserId();
            log.info("\u65b0\u7528\u6237[{}]\u53c2\u4e0e\u593a\u5b9d\u6d3b\u52a8[{}]", (Object)userId, (Object)phaseInfo.getPhaseId());
            if (context.getJoinTimesInfo().getFree().booleanValue()) {
                return LotteryJoinResultDTO.buildDefault();
            }
        }
        if (!(result = this.userAccountIntegrationService.deductGoldWithLottery((param = context.getParam()).getUserId(), phaseInfo.getExpendGold(), phaseInfo.getPhaseId(), phaseInfo.getLotteryTitle()))) {
            return LotteryJoinResultDTO.builder().joinResult(LotteryJoinResultEnum.GOLD_NOT_ENOUGH.getCode()).success(Boolean.valueOf(false)).build();
        }
        return LotteryJoinResultDTO.buildDefault();
    }

    @Override
    LotteryJoinResultDTO afterExecute(LotteryJoinContext context) {
        LotteryJoinResultDTO resultDTO = super.afterExecute(context);
        if (resultDTO.getSuccess().booleanValue()) {
            resultDTO = this.checkFollow(context);
            if (context.getJoinTimesInfo().getNewbie().booleanValue()) {
                Long userId = context.getParam().getUserId();
                log.info("\u65b0\u7528\u6237[{}]\u53c2\u4e0e\u6d3b\u52a8[{}]\u6210\u529f\uff0c\u6263\u9664\u4e00\u6b21\u514d\u8d39\u53c2\u4e0e\u673a\u4f1a", (Object)userId, (Object)context.getPhaseInfo().getPhaseId());
                this.lotteryCacheManage.consumeFreeJoinTime(userId);
            }
            this.bizLogIntegrationService.point(PointReportParam.build((BasicParam)context.getParam()).e("3034").ev("127." + context.getPhaseInfo().getPhaseId()).put("uid", String.valueOf(context.getParam().getUserId())).put("a", context.getParam().getAreaCode()));
        }
        return resultDTO;
    }

    @Override
    void fillParticipator(LotteryParticipatorEntity entity) {
        entity.setSource(LotteryJoinSourceEnum.APP.getCode());
        entity.setUserType(LotteryUserTypeEnum.ACTURAL.getCode());
    }

    @Override
    public boolean match(LotteryJoinContext context) {
        return null == context.getJoinSource() && !Objects.equals(PlatformEnum.WEB.getCode(), context.getParam().getPlatform());
    }
}

