/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.strategy.impl;

import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.dto.activity.LotteryPhaseCoreInfoDTO;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.event.LotteryShowEvent;
import com.bxm.localnews.merchant.service.lottery.strategy.impl.AbstractJoinStrategy;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirtualUserJoinStrategy
extends AbstractJoinStrategy {
    private static final Logger log = LoggerFactory.getLogger(VirtualUserJoinStrategy.class);

    @Override
    void fillParticipator(LotteryParticipatorEntity entity) {
        entity.setSource(LotteryJoinSourceEnum.VIRTUAL.getCode());
        entity.setUserType(LotteryUserTypeEnum.VIRTURAL.getCode());
    }

    @Override
    public boolean match(LotteryJoinContext context) {
        return LotteryJoinSourceEnum.VIRTUAL.equals((Object)context.getJoinSource());
    }

    @Override
    LotteryJoinResultDTO preCheck(LotteryJoinContext context) {
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        if (Boolean.TRUE.equals(context.getSkipTriggerDraw())) {
            return super.preCheck(context);
        }
        if (Objects.equals(phaseInfo.getVirtualFlag(), 0)) {
            log.info("\u6d3b\u52a8[{}]\u4e0d\u5141\u8bb8\u9a6c\u7532\u53f7\u53c2\u4e0e", (Object)phaseInfo.getPhaseId());
            return LotteryJoinResultDTO.builder().success(Boolean.valueOf(false)).build();
        }
        if (Boolean.TRUE.equals(context.getSkipActualLimit())) {
            return super.preCheck(context);
        }
        if (Objects.equals(phaseInfo.getActualFlag(), 1)) {
            boolean actualCondition;
            int num = phaseInfo.getTargetNum() - phaseInfo.getCurrentNum();
            boolean bl = actualCondition = num <= this.activityProperties.getMinimumActual();
            if (actualCondition) {
                int actualNum = this.getLotteryParticipatorService().countUserType(phaseInfo.getPhaseId(), LotteryUserTypeEnum.ACTURAL);
                if (num <= this.activityProperties.getMinimumActual() - actualNum) {
                    log.info("\u6d3b\u52a8[{}]\u5269\u4f59\u53c2\u4e0e\u4eba\u6570\u5fc5\u987b\u4fdd\u969c\u6700\u4f4e\u771f\u5b9e\u7528\u6237\u53c2\u4e0e\uff0c\u9a6c\u7532\u53f7\u53c2\u4e0e\u5931\u8d25.\u603b\u5171\u4eba\u6570\uff1a{},\u5f53\u524d\u53c2\u4e0e\u4eba\u6570\uff1a{}\uff0c\u771f\u5b9e\u7528\u6237\u53c2\u4e0e\u4eba\u6570\uff1a{}", new Object[]{phaseInfo.getPhaseId(), phaseInfo.getTargetNum(), phaseInfo.getCurrentNum(), actualNum});
                    return LotteryJoinResultDTO.builder().success(Boolean.valueOf(false)).build();
                }
            }
        }
        return super.preCheck(context);
    }

    @Override
    LotteryJoinResultDTO afterExecute(LotteryJoinContext context) {
        LotteryPhaseCoreInfoDTO phaseInfo = context.getPhaseInfo();
        this.lotteryStatisticsService.post(new LotteryShowEvent(phaseInfo.getLotteryId(), phaseInfo.getPhaseId()));
        return super.afterExecute(context);
    }
}

