/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.lottery.strategy.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.merchant.dto.activity.LotteryJoinResultDTO;
import com.bxm.localnews.merchant.entity.lottery.ActivityInviteHistoryEntity;
import com.bxm.localnews.merchant.entity.lottery.LotteryParticipatorEntity;
import com.bxm.localnews.merchant.param.activity.LotteryPhaseJoinParam;
import com.bxm.localnews.merchant.service.config.ActivityProperties;
import com.bxm.localnews.merchant.service.enums.LotteryJoinResultEnum;
import com.bxm.localnews.merchant.service.enums.LotteryJoinSourceEnum;
import com.bxm.localnews.merchant.service.enums.LotteryUserTypeEnum;
import com.bxm.localnews.merchant.service.lottery.LotteryInviteService;
import com.bxm.localnews.merchant.service.lottery.context.LotteryJoinContext;
import com.bxm.localnews.merchant.service.lottery.strategy.JoinStrategyManage;
import com.bxm.localnews.merchant.service.lottery.strategy.impl.AbstractJoinStrategy;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebJoinStrategy
extends AbstractJoinStrategy {
    private static final Logger log = LoggerFactory.getLogger(WebJoinStrategy.class);
    @Resource
    private LotteryInviteService lotteryInviteService;
    private JoinStrategyManage joinStrategyManage;
    @Resource
    private ActivityProperties activityProperties;

    private JoinStrategyManage getJoinStrategyManage() {
        if (null == this.joinStrategyManage) {
            this.joinStrategyManage = (JoinStrategyManage)SpringContextHolder.getBean(JoinStrategyManage.class);
        }
        return this.joinStrategyManage;
    }

    @Override
    public boolean match(LotteryJoinContext context) {
        return null == context.getJoinSource() && Objects.equals(PlatformEnum.WEB.getCode(), context.getParam().getPlatform());
    }

    @Override
    void fillParticipator(LotteryParticipatorEntity entity) {
        entity.setSource(LotteryJoinSourceEnum.WEB.getCode());
        entity.setUserType(LotteryUserTypeEnum.ACTURAL.getCode());
    }

    @Override
    LotteryJoinResultDTO preCheck(LotteryJoinContext context) {
        this.setJoinTimesInfo(context);
        LotteryJoinResultDTO check = this.checkTimes(context);
        if (check.getSuccess().booleanValue()) {
            return super.preCheck(context);
        }
        return check;
    }

    private LotteryJoinResultDTO checkTimes(LotteryJoinContext context) {
        if (this.activityProperties.getNoLimitWebJoinTimes().booleanValue()) {
            return LotteryJoinResultDTO.buildDefault();
        }
        if (context.getJoinTimesInfo().getJoinTimes() <= 0) {
            log.info("\u7528\u6237[{}]\u5df2\u65e0\u7ad9\u5916\u53c2\u4e0e\u6d3b\u52a8\u6b21\u6570", (Object)context.getParam().getUserId());
            return LotteryJoinResultDTO.builder().joinResult(LotteryJoinResultEnum.MAX_TIMES.getCode()).success(Boolean.valueOf(false)).build();
        }
        return LotteryJoinResultDTO.buildDefault();
    }

    @Override
    LotteryJoinResultDTO afterExecute(LotteryJoinContext context) {
        LotteryJoinResultDTO resultDTO = super.afterExecute(context);
        if (resultDTO.getSuccess().booleanValue()) {
            resultDTO = this.checkFollow(context);
            LotteryPhaseJoinParam param = context.getParam();
            this.lotteryCacheManage.consumeGlobalJoinTimes(param.getUserId());
            this.addInviteCode(param, context);
            this.bizLogIntegrationService.point(PointReportParam.build((BasicParam)context.getParam()).e("3034").ev("127." + context.getPhaseInfo().getPhaseId()).put("uid", String.valueOf(context.getParam().getUserId())).put("a", context.getParam().getAreaCode()));
        }
        return resultDTO;
    }

    private void addInviteCode(LotteryPhaseJoinParam param, LotteryJoinContext context) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u7ad9\u5916\u593a\u5b9d\u6d3b\u52a8\u6210\u529f\uff0c\u5f00\u59cb\u7ed9\u4e0a\u7ea7[{}]\u589e\u52a0\u593a\u5b9d\u5238", (Object)param.getUserId(), (Object)param.getShareUserId());
        }
        if (null == param.getShareUserId() || Objects.equals(param.getUserId(), param.getShareUserId())) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237[{}]\u7ad9\u5916\u53c2\u4e0e\u593a\u5b9d\u6d3b\u52a8[{}]\uff0c\u4e0d\u5b58\u5728\u5206\u4eab\u4eba\uff0c\u4e0d\u505a\u5904\u7406", (Object)param.getUserId(), (Object)param.getPhaseId());
            }
            return;
        }
        Long merchantUserId = context.getPhaseInfo().getMerchantUserId();
        if (param.getShareUserId().equals(merchantUserId)) {
            log.info("\u5546\u5bb6[{}]\u5206\u4eab\u7684\u593a\u5b9d\u6d3b\u52a8[{}]\uff0c\u4e0d\u7ed9\u5546\u5bb6\u53d1\u5238", (Object)merchantUserId, (Object)param.getPhaseId());
            return;
        }
        if (this.activityProperties.getMatchPhaseId().booleanValue() && !Objects.equals(param.getSourcePhaseId(), param.getPhaseId())) {
            log.info("\u7528\u6237[{}]\u7ad9\u5916\u53c2\u4e0e\u7684\u7684\u6d3b\u52a8[{}]\u4e0e\u539f\u59cb\u5206\u4eab\u6d3b\u52a8[{}]\u4e0d\u4e00\u81f4", new Object[]{param.getUserId(), param.getPhaseId(), param.getSourcePhaseId()});
            return;
        }
        if (!this.lotteryInviteService.match(param.getUserId(), param.getShareUserId(), param.getPhaseId())) {
            log.info("\u7528\u6237[{}]\u5df2\u7ecf\u5206\u4eab\u4eba[{}]\u52a9\u529b\u8fc7\u8be5\u6d3b\u52a8[{}]", new Object[]{param.getUserId(), param.getShareUserId(), param.getPhaseId()});
            return;
        }
        LotteryPhaseJoinParam inviteParam = new LotteryPhaseJoinParam();
        inviteParam.setPhaseId(param.getPhaseId());
        inviteParam.setUserId(param.getShareUserId());
        LotteryJoinContext inviteContext = LotteryJoinContext.builder().joinSource(LotteryJoinSourceEnum.INVITE).param(inviteParam).build();
        LotteryJoinResultDTO resultDTO = this.getJoinStrategyManage().execute(inviteContext);
        if (resultDTO.getSuccess().booleanValue()) {
            log.info("\u7528\u6237[{}]\u7ad9\u5916\u53c2\u4e0e\u6210\u529f\uff0c\u7ed9\u4e0a\u7ea7[{}]\u589e\u52a0\u593a\u5b9d\u5238\u6210\u529f", (Object)param.getUserId(), (Object)param.getShareUserId());
            this.saveInviteHistory(context);
        }
    }

    private void saveInviteHistory(LotteryJoinContext context) {
        LotteryPhaseJoinParam param = context.getParam();
        ActivityInviteHistoryEntity entity = new ActivityInviteHistoryEntity();
        entity.setBizId(param.getPhaseId());
        entity.setUserId(param.getUserId());
        entity.setInviteUserId(param.getShareUserId());
        entity.setCreateTime(new Date());
        entity.setNickName(context.getUserInfo().getNickname());
        entity.setHeadImg(context.getUserInfo().getHeadImg());
        this.lotteryInviteService.save(entity);
    }
}

