package com.bxm.localnews.merchant.common.config;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块}
 *
 * @author pf.w
 * @date 2020/7/13 11:43
 */

public class RedisConfig {

    private RedisConfig() {
    }

    /**
     * base key
     */
    private static DefaultKeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("merchant").setGroup("cache");

    /**
     * 商家列表缓存 new
     */
    public static KeyGenerator MERCHANT_LIST_WORK_KEY = BASE_KEY.copy().setKey("lists");

    /**
     * 用户收藏列表缓存  收藏商家id + 时间
     */
    public static KeyGenerator MERCHANT_COLLECT_MERCHANTS = BASE_KEY.copy().setKey("collectMerchantS");

    /**
     * 商家id
     */
    public static KeyGenerator MERCHANT_ID_KEY = BASE_KEY.copy().setKey("merchantId");

    /**
     * 用户关联的认证商家
     */
    public static KeyGenerator MERCHANT_USER_KEY = BASE_KEY.copy().setGroup("user");

    /**
     * 商家账户信息缓存 ： HASH
     */
    public static final KeyGenerator MERCHANT_ACCOUNT_KEY = BASE_KEY.copy().appendKey("cashInfo");

    /**
     * 今日浏览量
     */
    public static final KeyGenerator MERCHANT_VIEW_COUNTER = BASE_KEY.copy().appendKey("viewCounter");

    /**
     * 今日分享量
     */
    public static final KeyGenerator MERCHANT_SHARE_COUNTER = BASE_KEY.copy().appendKey("shareCounter");

    /**
     * 今日线索客户数
     */
    public static final KeyGenerator MERCHANT_CLICK_COUNTER = BASE_KEY.copy().appendKey("clickCounter");

    /**
     * 今日访客数
     */
    public static final KeyGenerator MERCHANT_GUEST_COUNTER = BASE_KEY.copy().appendKey("guestCounter");

    /**
     * 今日订单数
     */
    public static final KeyGenerator MERCHANT_ORDER_COUNTER = BASE_KEY.copy().appendKey("orderCounter");

    /**
     * 商家最近一条消息
     */
    public static KeyGenerator MERCHANT_MESSAGE_KEY = BASE_KEY.copy().setKey("merchantMessage");

    /**
     * 团队信息缓存 ： HASH
     */
    public static final KeyGenerator MEMBER_INFO_KEY = BASE_KEY.copy().appendKey("memberInfo");

    /**
     * 需要推送的用户信息
     */
    public static final KeyGenerator MERCHANT_CLICK_INFO_PUSH = BASE_KEY.copy().appendKey("merchantClickInfo");

    /**
     * 商家总账户缓存
     */
    public static final KeyGenerator MERCHANT_ACCOUNT_TOTAL = BASE_KEY.copy().appendKey("accountTotal");

    /**
     * 商家今日收入
     */
    public static final KeyGenerator MERCHANT_ACCOUNT_TODAY = BASE_KEY.copy().appendKey("accountToday");

    /**
     * 商品信息
     */
    public static final KeyGenerator MERCHANT_GOODS_KEY = BASE_KEY.copy().appendKey("goodsInfo");

    /**
     * 用户的商户信息缓存
     */
    public static KeyGenerator MERCHANT_USER_CACHE_KEY = BASE_KEY.copy().appendKey("merchant0k");

    /**
     * 每一个商品的浏览总数
     */
    public static final KeyGenerator GOODS_VIEW_COUNTER = BASE_KEY.copy().setKey("view_counter");

    /**
     * 每一个商品的浏览人信息
     */
    public static final KeyGenerator GOODS_VIEW_SET = BASE_KEY.copy().setKey("view_set");

    /**
     * 商品成交记录，用于显示
     */
    public static final KeyGenerator GOODS_ORDER_PAYMENT_SET = BASE_KEY.copy().setKey("order_payment_set");

    /**
     * 商家详情缓存
     */
    public static final KeyGenerator MERCHANT_INFO_CACHE = BASE_KEY.copy().setKey("merchant_info_cache");

    /**
     * 优惠券的状态机上下文信息存储
     */
    public static final KeyGenerator USER_COUPON_RECEIVE = DefaultKeyGenerator
            .build("merchant", "coupon", "cache")
            .copy()
            .appendKey("user");

    /**
     * 优惠券核销码
     */
    public static final KeyGenerator VERIFICATION_CODE_BUCKET = DefaultKeyGenerator
            .build("merchant", "coupon", "increment")
            .copy()
            .appendKey("code");

    /**
     * 优惠券信息缓存
     */
    public static final KeyGenerator COUPON_INFO_CACHE = DefaultKeyGenerator
            .build("merchant", "coupon", "cache")
            .copy()
            .appendKey("info");

    /**
     * 商家推荐的优惠券信息
     */
    public static final KeyGenerator COUPON_RECOMMEND_CACHE = DefaultKeyGenerator
            .build("merchant", "coupon", "cache")
            .copy()
            .appendKey("recommend");

    /**
     * 优惠券的领取人数打点，用于统计领取人数的UV
     */
    public static final KeyGenerator COUPON_RECEIVE_LOG = DefaultKeyGenerator
            .build("merchant", "coupon", "log")
            .copy()
            .appendKey("receive");

    /**
     * 今日领取优惠券的人数
     */
    public static final KeyGenerator COUPON_TODAY_RECEIVE_LOG = DefaultKeyGenerator
            .build("merchant", "coupon", "log")
            .copy()
            .appendKey("receive")
            .appendKey("day");

    /**
     * 优惠券的消耗人数打点，用于统计消耗人数的UV
     */
    public static final KeyGenerator COUPON_CONSUME_LOG = DefaultKeyGenerator
            .build("merchant", "coupon", "log")
            .copy()
            .appendKey("consume");

    /**
     * 今日消耗优惠券的人数UV
     */
    public static final KeyGenerator COUPON_TODAY_CONSUME_LOG = DefaultKeyGenerator
            .build("merchant", "coupon", "log")
            .copy()
            .appendKey("consume")
            .appendKey("day");

    /**
     * 参与夺宝活动的分布式锁
     */
    public static final KeyGenerator ACTIVITY_LOTTERY_RESOUCE_KEY = DefaultKeyGenerator
            .build("merchant", "lottery", "lock");

    /**
     * 用户参与夺宝活动的次数
     */
    public static final KeyGenerator USER_JOIN_TIMES_MAP = DefaultKeyGenerator
            .build("merchant", "lottery", "cache")
            .copy()
            .appendKey("join");

    /**
     * 活动期数的参与人数
     */
    public static final KeyGenerator PHASE_JOIN_NUM = DefaultKeyGenerator
            .build("merchant", "lottery", "cache")
            .copy()
            .appendKey("num");

    /**
     * 每日站外参与用户记录
     */
    public static final KeyGenerator TODAY_GLOBAL_JOIN_USER = DefaultKeyGenerator
            .build("merchant", "lottery", "cache")
            .copy()
            .appendKey("global");

    /**
     * 用户免费参与夺宝活动的次数记录
     */
    public static final KeyGenerator LOTTERY_FREE_JOIN_USER = DefaultKeyGenerator
            .build("merchant", "lottery", "cache")
            .copy()
            .appendKey("free");

    /**
     * 参与夺宝的虚拟用户
     */
    public static final KeyGenerator LOTTERY_TEMP_VIRTUAL_KEY = DefaultKeyGenerator
            .build("merchant", "lottery", "cache")
            .copy()
            .appendKey("virtual");

    /**
     * 夺宝活动奖品的核销码
     */
    public static final KeyGenerator PRIZE_VERIFICATION_CODE_BUCKET = DefaultKeyGenerator
            .build("merchant", "lottery", "increment")
            .copy()
            .appendKey("code");

    /**
     * 获取用户关注领取的优惠券
     */
    public static final KeyGenerator USER_FOLLOW_COUPON = DefaultKeyGenerator
            .build("merchant", "lottery", "follow")
            .copy()
            .appendKey("user");

    /**
     * 不同区域，各个行业中5折会员日商品的数量缓存
     */
    public static final KeyGenerator INDUSTRY_MEMBER_GOODS_COUNT = DefaultKeyGenerator
            .build("merchant", "industry", "memberDayGoods")
            .copy()
            .appendKey("count");
}
