package com.bxm.localnews.merchant.common.constant;

/**
 * @author Administrator
 * @date 2020/9/1 10:36
 **/
public enum MerchantGoodsEnum {


    //推送类型
    PUSH_GOODS_LESSTEN(0, "商品库存小于10"),
    PUSH_GOODS_SELLOUT(1, "商品售罄"),

    //审核类型
    AUDIT_GOODS_BACK(0, "撤销审核"),
    AUDIT_GOODS_IN(1, "审核中"),
    AUDIT_GOODS_SUCCESS(2, "审核成功"),
    AUDIT_GOODS_FAIL(3, "审核失败"),

    //上下架状态
    GOODS_SHELF_DOWN(0,"下架"),
    GOODS_SHELF_UP(1,"上架"),

    //页面类型  0出售中1审核中2已售罄3已下架
    PAGE_GOODS_SALEIN(0, "出售中页面"),
    PAGE_GOODS_AUDIT(1, "审核中页面"),
    PAGE_GOODS_SALEOUT(2, "已售罄页面"),

    ERRORMERCHANTMES(0,"沒有找到该商户"),
    ERRORGOODSMES(1,"没有找到该商品"),
    FAILMES(2,"乐观锁失败,MerchantGoodsVo:"),

    GOODS_RATE_MAX(99,"最大佣金比例"),
    GOODS_SUM_MAX(15,"最大商品数")
    ;

    //商品最小价格
    public final static double GOODS_PRICE_MIN = 0.01;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    MerchantGoodsEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
