package com.bxm.localnews.merchant.common.enums;

/**
 * 商品分类类型枚举
 *
 * @author wzy
 * @date 2020年11月23日16:45:42
 */
public enum GoodsCategoryTypeEnum {
    /**
     * 普通商品
     */
    ORDINARY(0, "普通商品"),

    /**
     * 五折会员日商品
     */
    MEMBER_DAY(1, "五折会员日商品"),

    /**
     * 优惠团购商品
     */
    DISCOUNT_GROUP(2, "优惠团购商品");

    GoodsCategoryTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * code
     */
    private Integer code;

    /**
     * 描述
     */
    private String msg;

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
