package com.bxm.localnews.merchant.common.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * 团购订单状态
 *
 * @author gonzo
 * @date 2020-12-10 21:49
 **/
public enum GroupOrderStates {
    /**
     * 待支付
     */
    WAIT_PAY(3),

    /**
     * 支付成功
     */
    PAY_SUCCESS(6),

    /**
     * 消费成功
     */
    CONSUME_SUCCESS(7),

    /**
     * 退款中
     */
    REFUNDING(8),

    /**
     * 已失效
     */
    DISABLE(9),

    // 以下状态已废弃，挪到了子状态中，但客户端还在使用，所以依然保留定义
    /**
     * ：超时未支付
     */
    @Deprecated
    TIME_OUT(4),

    /**
     * 5：取消支付
     */
    @Deprecated
    CANCEL(5),

    /**
     * 10:拒绝退单待核销
     */
    @Deprecated
    REFUSE_REFUND_WAIT_CONSUME(10),

    ;

    private int status;

    GroupOrderStates(int status) {
        this.status = status;
    }

    public static GroupOrderStates getByCode(Integer orderStatus) {
        Optional<GroupOrderStates> any = Arrays.stream(GroupOrderStates.values()).filter(p -> p.getStatus() == orderStatus).findAny();

        return any.orElse(null);
    }

    public int getStatus() {
        return status;
    }
}
