package com.bxm.localnews.merchant.common.enums;

import java.util.Arrays;

import static com.bxm.localnews.merchant.common.enums.GroupOrderStates.DISABLE;
import static com.bxm.localnews.merchant.common.enums.GroupOrderStates.PAY_SUCCESS;


/**
 * 团购订单子状态
 *
 * @author gonzo
 * @date 2020-12-10 21:49
 **/
public enum GroupOrderSubStates {

    /**
     * 超时未支付失效
     */
    DISABLE_BY_TIME_OUT_CANCEL(1, DISABLE),

    /**
     * 手动取消订单的失效
     */
    DISABLE_BY_MANUAL_CANCEL(2, DISABLE),

    /**
     * 手动退款成功之后的失效
     */
    DISABLE_BY_MANUAL_REFUND(3, DISABLE),

    /**
     * 自动退款成功之后的失效
     */
    DISABLE_BY_AUTO_REFUND(4, DISABLE),

    /**
     * 拒绝退款之后的支付成功（待使用）
     */
    PAY_SUCCESS_BY_REFUND_REFUSE(1, PAY_SUCCESS),

    ;

    private int status;

    private GroupOrderStates parent;

    GroupOrderSubStates(int status, GroupOrderStates parent) {
        this.status = status;
        this.parent = parent;
    }

    public static GroupOrderSubStates getByStatus(int status) {
        return Arrays.stream(GroupOrderSubStates.values()).filter(p -> p.getStatus() == status).findAny().orElse(DISABLE_BY_MANUAL_REFUND);
    }

    public int getStatus() {
        return status;
    }

    public GroupOrderStates getParent() {
        return parent;
    }
}
