package com.bxm.localnews.merchant.common.enums;

/**
 * 商家账户流水类型
 *
 * @author pf.w
 * @date 2020/8/23 11:23
 **/
public enum MerchantBossAccountCashTypeEnum {
    /**
     * 用户付款金额
     */
    CASH_PAYMENT(0, "收入"),

    /**
     * 收入打款产生手续费用
     */
    CASH_INCOME_CHARGE(1, "手续费"),

    /**
     * 提现
     */
    CASH_WITHDRAW_SUCCESS(2, "提现"),

    CASH_WITHDRAW_FALSE(3, "提现失败"),

    /**
     * 商家收入后分销金额
     */
    CASH_DIVIDE(4, "分销佣金"),

    CASH_WITHDRAW_ING(5, "提现中"),

    /**
     * 退单退款
     */
    CASH_DRAWBACK(6, "商品退款"),

    /**
     * 退单退款时退还商家手续费
     */
    CASH_OUT_CHARGE(7, "手续费退还"),

    /**
     * 退单退款时退还商家的分佣金额
     */
    CASH_WITHDRAW_SUCCESS_CHARGE(8, "分销佣金退还"),

    /**
     * 平台补贴
     */
    PLATFORM_SUBSIDY(9, "平台补贴"),

    /**
     * 现金红包手续费
     */
    REWARD_CASH_INCOME_CHARGE(10, "现金红包手续费");

    /**
     * 流水类型
     */
    private int code;

    /**
     * 类型描述
     */
    private String desc;

    MerchantBossAccountCashTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
